package com.cku.oa.goods.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.goods.service.SysBusinessCateService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.goods.entity.SysBusinessService;
import com.cku.oa.goods.service.SysBusinessServiceService;

/**
 * 业务服务Controller
 *
 * @author yuanshuai
 * @version 2023-06-16
 */
@Controller
@RequestMapping(value = "${adminPath}/goods/sysBusinessService")
public class SysBusinessServiceController extends BaseController {

	@Autowired
	private SysBusinessServiceService sysBusinessServiceService;
	@Autowired
	private SysBusinessCateService sysBusinessCateService;

	@ModelAttribute
	public SysBusinessService get(@RequestParam(required = false) String id) {
		SysBusinessService entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = sysBusinessServiceService.get(id);
		}
		if (entity == null) {
			entity = new SysBusinessService();
		}
		return entity;
	}

	@RequiresPermissions("goods:sysBusinessService:view")
	@RequestMapping(value = {"list", ""})
	public String list(SysBusinessService sysBusinessService, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<SysBusinessService> page = sysBusinessServiceService.findPage(new Page<>(request, response), sysBusinessService);
		model.addAttribute("page", page);
		model.addAttribute("businessCateList", sysBusinessCateService.findAllList());
		return "oa/goods/sysBusinessServiceList";
	}

	@RequiresPermissions("goods:sysBusinessService:view")
	@RequestMapping(value = "viewForm")
	public String viewForm(SysBusinessService sysBusinessService, Model model) {
		model.addAttribute("businessCateList", sysBusinessCateService.findAllList());
		model.addAttribute("isView", 1);
		model.addAttribute("sysBusinessService", sysBusinessService);
		return "oa/goods/sysBusinessServiceForm";
	}

	@RequiresPermissions("goods:sysBusinessService:edit")
	@RequestMapping(value = "editForm")
	public String editForm(SysBusinessService sysBusinessService, Model model) {
		model.addAttribute("businessCateList", sysBusinessCateService.findAllList());
		model.addAttribute("isView", 0);
		model.addAttribute("sysBusinessService", sysBusinessService);
		return "oa/goods/sysBusinessServiceForm";
	}

	@RequiresPermissions("goods:sysBusinessService:edit")
	@RequestMapping(value = "save")
	public String save(SysBusinessService sysBusinessService, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, sysBusinessService)) {
			return editForm(sysBusinessService, model);
		}
		try {
			sysBusinessServiceService.save(sysBusinessService);
			addMessage(redirectAttributes, "保存业务服务成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "保存业务服务失败：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/goods/sysBusinessService/?repage";
	}

	@RequiresPermissions("goods:sysBusinessService:del")
	@RequestMapping(value = "delete")
	public String delete(SysBusinessService sysBusinessService, RedirectAttributes redirectAttributes) {
		try {
			sysBusinessServiceService.delete(sysBusinessService);
			addMessage(redirectAttributes, "删除业务服务成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "删除业务服务失败：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/goods/sysBusinessService/?repage";
	}

}