package com.cku.oa.finance.web.statistics;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cku.oa.finance.dao.MemberAccountDao;
import com.cku.oa.finance.dao.statistics.FinanceStatisticsDao;
import com.cku.oa.finance.entity.MemberAccount;
import com.cku.oa.show.dao.ShowApplyDao;
import com.cku.oa.show.entity.ShowApply;
import com.cku.oa.statistics.dao.ActivityRegisterDao;
import com.cku.oa.statistics.entity.ShopSalesStatistics;
import com.cku.oa.statistics.entity.ShowOfficeRegion;
import com.cku.oa.statistics.service.ShopSalesStatisticsService;
import com.cku.oa.statistics.service.ShowOfficeRegionService;
import com.cku.oa.statistics.vo.RegionVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.Encodes;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;


/**
 * 财务统计
 * @author xuzhenxing
 *
 */

@Controller
@RequestMapping(value = "${adminPath}/finance/statistics/")
public class FinanceStatisticsController {

	@Autowired
	private FinanceStatisticsDao financeStatisticsDao;
	@Autowired
	private ShopSalesStatisticsService shopSalesStatisticsService;
	@Autowired
	private ActivityRegisterDao activityRegisterDao;
	@Autowired
    private MemberAccountDao memberAccountDao;
	@Autowired
	private ShowApplyDao showApplyDao;
	@Autowired
	private ShowOfficeRegionService showOfficeRegionService;

	private static final String LOVE_CUTE_DOG_OFFICE_NO = "100000022";

	@RequestMapping(value = "revenue")
	public String revenueView(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
		String nowDate = request.getParameter("nowDate");
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String isOnSubmit = request.getParameter("isOnSubmit");
		double countAll = 0;

		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH )+1;
		int day = cal.get(Calendar.DAY_OF_MONTH);

		if(isOnSubmit == null || isOnSubmit.equals(""))
		{
			if(startDate == null || startDate.equals(""))
				startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
			if(endDate == null || endDate.equals(""))
				endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
		}else if(isOnSubmit.equals("1")){
			if(nowDate == null || !nowDate.equals("")){
				if(nowDate.equals("year"))
				{
					startDate = String.valueOf(year)+"-01-01 00:00:00";
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
				}else if(nowDate.equals("month")){
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01 00:00:00";
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
				}
			}
		}

		Map classification = financeStatisticsDao.classification(startDate, endDate);
		double payOnAccount = financeStatisticsDao.payOnAccount(startDate, endDate);
		List<Map> e_mall = financeStatisticsDao.e_mall(startDate, endDate);

		countAll += payOnAccount;
		for(int i=0; i<e_mall.size();i++)
		{
			if(!e_mall.get(i).get("paymentWay").toString().equals("9"))
			countAll +=((java.math.BigDecimal)e_mall.get(i).get("revenue")).doubleValue();
		}
		for (Object key : classification.keySet()) {
			if(!key.toString().equals("import"))
			countAll +=((java.math.BigDecimal)classification.get(key)).doubleValue();
		}
		classification.put("payOnAccount", payOnAccount);
		model.addAttribute("countAll",countAll);
		model.addAttribute("classification",classification);
		model.addAttribute("e_mall",e_mall);
		model.addAttribute("startDate", startDate);
		model.addAttribute("endDate", endDate);
		return "oa/finance/statistics/revenue";
	}

	@RequestMapping(value = "charge")
	public String chargeView(HttpServletRequest request, HttpServletResponse response, Model model) throws ParseException {
		//犬只参赛费（××合办 单独处理）
		final String[] showApplyArray = {"140", "142", "220", "222", "298", "298zz"};
		final String[] showApplyDeptArray = {"b03e768686c64608852b6ed57ce20911", "8c9825c10d714397b464ec796435748a", "c2ce7357a6a945008a5cd3d264b384f1", "d709ba143756439a81e96effa08b2a82", "169ce55393644a8a8f35d21918e141ff", "169ce55393644a8a8f35d21918e141zz"};
		String officeType = request.getParameter("officeType");
		String nowDate = request.getParameter("nowDate");
		String isOnSubmit = request.getParameter("isOnSubmit");
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String searchFlag = request.getParameter("searchFlag");
		//添加各部门统计功能
		String officeNo = request.getParameter("officeNo");
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH) + 1;
		int day = cal.get(Calendar.DAY_OF_MONTH);

		if (isOnSubmit == null || isOnSubmit.equals("")) {
			if (startDate == null || startDate.equals(""))
				startDate = String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day) + " 00:00:00";
			if (endDate == null || endDate.equals(""))
				endDate = String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day) + " 23:59:59";
		} else if (isOnSubmit.equals("1")) {
			if (nowDate == null || !nowDate.equals("")) {
				if (nowDate.equals("year")) {
					startDate = String.valueOf(year) + "-01-01 00:00:00";
					endDate = String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day) + " 23:59:59";
				} else if (nowDate.equals("month")) {
					startDate = String.valueOf(year) + "-" + String.valueOf(month) + "-01 00:00:00";
					endDate = String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day) + " 23:59:59";
				}
			}
		}

		double chargeTotal = 0;    //业务扣费总计金额
		List<Map> officeName = financeStatisticsDao.officeName(officeNo);    //部门名称
		List<Map> chargeItem = financeStatisticsDao.charge(startDate, endDate, officeNo);    //扣费项目
		List<Map> chargeDetails = new ArrayList();
		ShopSalesStatistics shopSalesStatistics = new ShopSalesStatistics();
		shopSalesStatistics.setStatisticalDateFrom(startDate);
		shopSalesStatistics.setStatisticalDateTo(endDate);
		List<ShopSalesStatistics> salesStatistics = shopSalesStatisticsService.findList(shopSalesStatistics);
		//如果部门是美容，则将爱萌犬的部门也加上
		if ("100000004".equals(officeNo)) {
			//officeNo : 100000022 为爱萌犬部门编码
			List<Map> loveCuteDogOfficeName = financeStatisticsDao.officeName(LOVE_CUTE_DOG_OFFICE_NO);    //部门名称
			if (CollectionUtils.isNotEmpty(loveCuteDogOfficeName)) {
				officeName.addAll(loveCuteDogOfficeName);
			}
		}
		//按部分分组
		for (Map<String, Object> office : officeName) {
			List<Map> myDetails = Lists.newArrayList();
			double corpNum = 0, corpFee = 0;//合作机构
			double memberNum = 0, memberFee = 0;//会员中心
			double orderNum = 0, orderFee = 0;//业务订单
			double OANum = 0, OAFee = 0;//OA扣费
			double countNum = 0, countFee = 0;//总数
			Map<String, Object> countAll = new HashMap<String, Object>();
			Map<String, Object> content = new HashMap<String, Object>();
			//商品部特殊处理
			if (office.get("name").equals("商品部")) {
				if (salesStatistics.size() > 0) {
					for (ShopSalesStatistics ss : salesStatistics) {
						Map<String, Object> sales = new HashMap<String, Object>();
						sales.put("id", office.get("id"));
						sales.put("chargeID", office.get("id"));
						sales.put("chargeItem", ss.getCommodityName());
						sales.put("corpNum", new BigDecimal("0"));
						sales.put("corpFee", new BigDecimal("0.00"));
						sales.put("memberNum", new BigDecimal("0"));
						sales.put("memberFee", new BigDecimal("0.00"));
						sales.put("orderNum", new BigDecimal("0"));
						sales.put("orderFee", new BigDecimal("0.00"));
						sales.put("OANum", new BigDecimal("0"));
						sales.put("OAFee", new BigDecimal("0.00"));
						sales.put("countNum", new BigDecimal(ss.getCommodityNum()));
						sales.put("countFee", new BigDecimal(ss.getTotalAmount()));
						chargeItem.add(sales);
					}
				}
			}
			//处理其他部门
			content.put("officeName", office.get("name"));
			for (Map<String, Object> charge : chargeItem) {
				if (office.get("id").equals(charge.get("id"))) {
					Map<String, Object> myCharge = Maps.newHashMap();
					myCharge.put("chargeID", charge.get("chargeID"));
					myCharge.put("chargeItem", charge.get("chargeItem"));
					myCharge.put("corpNum", charge.get("corpNum"));
					myCharge.put("corpNum", charge.get("corpNum"));
					myCharge.put("corpFee", charge.get("corpFee"));
					myCharge.put("memberNum", charge.get("memberNum"));
					myCharge.put("memberFee", charge.get("memberFee"));
					myCharge.put("orderNum", charge.get("orderNum"));
					myCharge.put("orderFee", charge.get("orderFee"));
					myCharge.put("OANum", charge.get("OANum"));
					myCharge.put("OAFee", charge.get("OAFee"));
					myCharge.put("countNum", charge.get("countNum"));
					myCharge.put("countFee", charge.get("countFee"));
					corpNum += ((java.math.BigDecimal) charge.get("corpNum")).doubleValue();
					corpFee += ((java.math.BigDecimal) charge.get("corpFee")).doubleValue();
					memberNum += ((java.math.BigDecimal) charge.get("memberNum")).doubleValue();
					memberFee += ((java.math.BigDecimal) charge.get("memberFee")).doubleValue();
					orderNum += ((java.math.BigDecimal) charge.get("orderNum")).doubleValue();
					orderFee += ((java.math.BigDecimal) charge.get("orderFee")).doubleValue();
					OANum += Double.parseDouble(charge.get("OANum").toString());
					OAFee += ((java.math.BigDecimal) charge.get("OAFee")).doubleValue();
					countNum += ((java.math.BigDecimal) charge.get("countNum")).doubleValue();
					countFee += ((java.math.BigDecimal) charge.get("countFee")).doubleValue();
					myDetails.add(myCharge);
					if (!content.get("officeName").equals("财务部") && !content.get("officeName").equals("合作单位"))
						chargeTotal += Double.parseDouble(charge.get("countFee").toString());
				}
			}
			countAll.put("countCoreNum", corpNum);
			countAll.put("countCoreFee", corpFee);
			countAll.put("countMemberNum", memberNum);
			countAll.put("countMemberFee", memberFee);
			countAll.put("countOrderNum", orderNum);
			countAll.put("countOrderFee", orderFee);
			countAll.put("countOANum", OANum);
			countAll.put("countOAFee", OAFee);
			countAll.put("totalCountNum", countNum);
			countAll.put("totalCountFee", countFee);
			content.put("totalCount", countAll);
			content.put("chargeItem", myDetails);
			chargeDetails.add(content);
		}

		List<String> showChargeItemID = financeStatisticsDao.showChargeItemID();
		List<String> showChargeCouponItemID = financeStatisticsDao.showChargeCouponItemID();
		model.addAttribute("showChargeItemID", showChargeItemID);
		model.addAttribute("showChargeCouponItemID", showChargeCouponItemID);
		model.addAttribute("chargeDetails", chargeDetails);
		model.addAttribute("chargeTotal", chargeTotal);
		model.addAttribute("startDate", startDate);
		model.addAttribute("endDate", endDate);
		String result = null;
		if (officeType == null) {
			result = "oa/finance/statistics/charge";
		} else {
			if (officeNo != null && !"".equals(officeNo)) {
				model.addAttribute("officeNo", officeNo);
				result = "oa/finance/statistics/officeCharge";
			}
		}
		return result;
	}

	@RequestMapping(value = "orderList")
	public String orderList(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
		Page<User> page = new Page<User>(request, response);//从页面的参数中获取当前的页码等信息
		page.setPageSize(20); //每页的大小

		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String orderCode = request.getParameter("orderCode");
		String memberCode = request.getParameter("memberCode");
		String memberName = request.getParameter("memberName");
		String chargingItemID = request.getParameter("chargingItemID");
		String projectID = request.getParameter("projectID");
		String voucherCode = request.getParameter("voucherCode");
		String paymentState = request.getParameter("paymentState");
		String orderType = request.getParameter("orderType");
		String nowDate = request.getParameter("nowDate");
		String totalPrice = request.getParameter("totalPrice");
		String isOnSubmit = request.getParameter("isOnSubmit");
		String isShowCoupon = request.getParameter("isShowCoupon");

		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH )+1;
		int day = cal.get(Calendar.DAY_OF_MONTH);

		if(isOnSubmit == null || isOnSubmit.equals(""))
		{
			if(startDate == null || startDate.equals(""))
				startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
			if(endDate == null || endDate.equals(""))
				endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
		}else if(isOnSubmit.equals("1")){
			if(nowDate == null || !nowDate.equals("")){
				if(nowDate.equals("year"))
				{
					startDate = String.valueOf(year)+"-01-01 00:00:00";
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
				}else if(nowDate.equals("month")){
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01 00:00:00";
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
				}
			}
		}

		Map countOrder = financeStatisticsDao.countOrder(totalPrice, orderCode, memberCode, memberName, orderType, chargingItemID, projectID, voucherCode, paymentState, startDate, endDate);
		List<Map> orderList = financeStatisticsDao.orderList(totalPrice, orderCode, memberCode, memberName, orderType, chargingItemID, projectID, voucherCode, paymentState, startDate, endDate, (page.getPageNo()-1)*page.getPageSize(),page.getPageSize());
		if(StringUtils.isNotBlank(isShowCoupon)){
			for(Map map:orderList){
				map.put("show_code","");
				String chargind_item_id = map.get("charging_item_id").toString();
					String ids = map.get("business_ids").toString();
					//查询赛事
					if(StringUtils.isNotBlank(ids)){
						String[] split = ids.split("#");
						//
						ShowApply showApply = showApplyDao.get(split[0]);
						map.put("show_code",showApply.getShowCode());
					}
			}
		}
		List<Map> chargingItemOption=financeStatisticsDao.chargeItemOption();
        List<Map> chargeCouponItemOption = financeStatisticsDao.chargeCouponItemOption();
		model.addAttribute("chargeCouponItemOption", chargeCouponItemOption);
		model.addAttribute("isShowCoupon", isShowCoupon);
		model.addAttribute("startDate", startDate);
		model.addAttribute("endDate", endDate);
		model.addAttribute("orderCode", orderCode);
		model.addAttribute("memberCode", memberCode);
		model.addAttribute("memberName", memberName);
		model.addAttribute("chargingItemID", chargingItemID);
		model.addAttribute("projectID", projectID);
		model.addAttribute("voucherCode", voucherCode);
		model.addAttribute("paymentState", paymentState);
		model.addAttribute("orderType", orderType);
		model.addAttribute("totalPrice", totalPrice);
		model.addAttribute("countOrder",countOrder);
		model.addAttribute("orderList",orderList);
		model.addAttribute("chargeItemOption",chargingItemOption);
		page.setCount(Integer.parseInt(countOrder.get("countNum").toString())); //总条数
		page.initialize();//初始化
		model.addAttribute("page", page);
		return "oa/finance/statistics/orderList";
	}

    @RequestMapping(value = "export")
    public String export(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String paymentState = request.getParameter("paymentState");
        String chargingItemID = request.getParameter("chargingItemID");
        String chargeItem = request.getParameter("chargeItem");
       
        String source = request.getParameter("source");
        
		List<String> showChargeItemID = financeStatisticsDao.showChargeItemID();
		List<String> showCouponChargeItemID = financeStatisticsDao.showChargeCouponItemID();
		List<Map> exportList = new ArrayList<Map>();
		List<Map> corpList = new ArrayList<>();
		List<Map> orderList = new ArrayList<>();
        if(!StringUtils.isEmpty(source) && source.equals("region")) {
        	String province = request.getParameter("province");
    		List<RegionVo> regions = new ArrayList<>();
	       	if(StringUtils.isEmpty(province)) {
	    		regions = showOfficeRegionService.findRegionList();
	       	}
        	corpList = financeStatisticsDao.regionOrderList("", "", "", "", "corp", chargingItemID, "", "", paymentState, startDate, endDate, 0,10000, province,regions);
    		orderList = financeStatisticsDao.regionOrderList("", "", "", "", "order", chargingItemID, "", "", paymentState, startDate, endDate, 0,10000,province,regions);
				
		}else {
			corpList = financeStatisticsDao.orderList("", "", "", "", "corp", chargingItemID, "", "", paymentState, startDate, endDate, 0,10000);
			orderList = financeStatisticsDao.orderList("", "", "", "", "order", chargingItemID, "", "", paymentState, startDate, endDate, 0,10000);
		}
		
		exportList.addAll(corpList);
		exportList.addAll(orderList);
		List<Map> showOrderList = new ArrayList<Map>();
		if(showChargeItemID.contains(chargingItemID)){
			showOrderList = activityRegisterDao.showOrderList("","","member",chargingItemID,paymentState,"", "", "", "", startDate, endDate, 0,10000);
		}else if(showCouponChargeItemID.contains(chargingItemID)){
			showOrderList = activityRegisterDao.showOrderCouponList("","","member",chargingItemID,paymentState,"", "", "", "", startDate, endDate, 0,10000);
		}else{
			showOrderList = financeStatisticsDao.orderList("", "", "", "", "member", chargingItemID, "", "", paymentState, startDate, endDate, 0,10000);
		}
		exportList.addAll(showOrderList);
		String fileName = chargeItem+"("+startDate+"---"+endDate+")业务扣费明细.xls";
		response.reset();
        response.setContentType("application/octet-stream; charset=utf-8");
        response.setHeader("Content-Disposition", "attachment; filename="+Encodes.urlEncode(fileName));
		//创建excel
        HSSFWorkbook workBook = new HSSFWorkbook();
        CellStyle indexStyle = workBook.createCellStyle();
        CellStyle contentStyle = workBook.createCellStyle();
        CellStyle titleStyle = workBook.createCellStyle();
        titleStyle.setAlignment(CellStyle.ALIGN_CENTER);
        titleStyle.setVerticalAlignment(CellStyle.VERTICAL_CENTER);
        HSSFFont font = workBook.createFont();
        font.setFontName("仿宋_GB2312");
        font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);//粗体显示
        font.setFontHeightInPoints((short) 12);  //字体大小
        titleStyle.setFont(font);
        contentStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN); //下边框
        contentStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);//左边框
        contentStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);//上边框
        contentStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);//右边框
        indexStyle.setAlignment(CellStyle.ALIGN_CENTER);
        indexStyle.setFillForegroundColor(HSSFColor.LIGHT_YELLOW.index);
        indexStyle.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
        indexStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN); //下边框
        indexStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);//左边框
        indexStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);//上边框
        indexStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);//右边框
        //开始制表
		HSSFSheet sheet = null;
		if(showChargeItemID.contains(chargingItemID)){
			sheet = workBook.createSheet("合作机构、业务订单");
		}else{
			sheet = workBook.createSheet("合作机构、会员中心、业务订单");
		}
        Row indexRow = sheet.createRow(0);
        indexRow.createCell(0).setCellValue("序号");
        indexRow.createCell(1).setCellValue("订单编号");
        sheet.setColumnWidth(1, 30 * 256);
        indexRow.createCell(2).setCellValue("会员号");
        sheet.setColumnWidth(2, 15 * 256);
        indexRow.createCell(3).setCellValue("会员名");
        sheet.setColumnWidth(3, 30 * 256);
        indexRow.createCell(4).setCellValue("业务名称");
        sheet.setColumnWidth(4, 35 * 256);
        indexRow.createCell(5).setCellValue("单价");
        sheet.setColumnWidth(5, 10 * 256);
        indexRow.createCell(6).setCellValue("数量");
        sheet.setColumnWidth(6, 10 * 256);
        indexRow.createCell(7).setCellValue("总价");
        sheet.setColumnWidth(7, 10 * 256);
        indexRow.createCell(8).setCellValue("标识");
        sheet.setColumnWidth(8, 30 * 256);
        indexRow.createCell(9).setCellValue("凭证号");
        sheet.setColumnWidth(9, 10 * 256);
        indexRow.createCell(10).setCellValue("时间");
        sheet.setColumnWidth(10, 20 * 256);
        indexRow.createCell(11).setCellValue("缴费状态");
        sheet.setColumnWidth(11, 10 * 256);
        for (Cell cell : indexRow) {
        	cell.setCellStyle(indexStyle);
        }
        // 填充数据
        int i = 1;
        for (Map  map : exportList) {
        	 Row row = sheet.createRow(i);
             row.createCell(0).setCellValue(i);
             row.createCell(1).setCellValue(map.get("order_code") == null ? "" : map.get("order_code").toString());
             row.createCell(2).setCellValue(map.get("member_code") == null ? "" : map.get("member_code").toString());
             row.createCell(3).setCellValue(map.get("name") == null ? "" : map.get("name").toString());
             row.createCell(4).setCellValue(map.get("charging_item_name") == null ? "" : map.get("charging_item_name").toString());
             row.createCell(5).setCellValue(map.get("price") == null ? "" : map.get("price").toString());
             row.createCell(6).setCellValue(map.get("num") == null ? "" : map.get("num").toString());
             row.createCell(7).setCellValue(map.get("total_price") == null ? "0" : map.get("total_price").toString());
             row.createCell(8).setCellValue(map.get("project_id") == null ? "" : map.get("project_id").toString());
             row.createCell(9).setCellValue(map.get("voucher_code") == null ? "" : map.get("voucher_code").toString());
             row.createCell(10).setCellValue(map.get("payment_time") == null ? "" : map.get("payment_time").toString());
             row.createCell(11).setCellValue(map.get("payment_state") == null ? "" : map.get("payment_state").toString());
             // 设置列的样式
             for (Cell cell : row) {cell.setCellStyle(contentStyle);}
             i++;
		}

		MemberAccount memberAccount = new MemberAccount();
		memberAccount.setChargingItemId(chargingItemID);
		memberAccount.setPaymentTimeStart(DateUtils.parseDate(startDate));
		memberAccount.setPaymentTimeEnd(DateUtils.parseDate(endDate));
		memberAccount.setDelFlag("0");
		memberAccount.setIsNewRecord(false);
		List<MemberAccount> list = memberAccountDao.findList(memberAccount);
        HSSFSheet sheet2 = workBook.createSheet("OA扣费");
        Row indexRow2 = sheet2.createRow(0);
        indexRow2.createCell(0).setCellValue("序号");
        indexRow2.createCell(1).setCellValue("流水号");
        sheet2.setColumnWidth(1, 20 * 256);
        indexRow2.createCell(2).setCellValue("会员号");
        sheet2.setColumnWidth(2, 15 * 256);
        indexRow2.createCell(3).setCellValue("会员名");
        sheet2.setColumnWidth(3, 30 * 256);
        indexRow2.createCell(4).setCellValue("金额");
        sheet2.setColumnWidth(4, 10 * 256);
        indexRow2.createCell(5).setCellValue("部门");
        sheet2.setColumnWidth(5, 20 * 256);
        indexRow2.createCell(6).setCellValue("收支类型");
        sheet2.setColumnWidth(6, 30 * 256);
        indexRow2.createCell(7).setCellValue("支付方式");
        sheet2.setColumnWidth(7, 15 * 256);
        indexRow2.createCell(8).setCellValue("缴费时间");
        sheet2.setColumnWidth(8, 20 * 256);
        indexRow2.createCell(9).setCellValue("备注");
		sheet2.setColumnWidth(9, 30 * 256);
		indexRow2.createCell(10).setCellValue("操作人");
		sheet2.setColumnWidth(10, 20 * 256);
        for (Cell cell : indexRow2) {
        	cell.setCellStyle(indexStyle);
        }
        // 填充数据
		int j = 1;
        for (MemberAccount mc : list) {
        	 Row row = sheet2.createRow(j);
             row.createCell(0).setCellValue(j);
             row.createCell(1).setCellValue(mc.getRunningNumber() == null ? "" : mc.getRunningNumber().toString());
             row.createCell(2).setCellValue(mc.getMemberCode() == null ? "" : mc.getMemberCode().toString());
             row.createCell(3).setCellValue(mc.getMemberName() == null ? "" : mc.getMemberName().toString());
             row.createCell(4).setCellValue(mc.getPaymentAmount() == null ? "" : mc.getPaymentAmount().toString());
             row.createCell(5).setCellValue(mc.getChargingItemOfficeName() == null ? "" : mc.getChargingItemOfficeName().toString());
             row.createCell(6).setCellValue(mc.getChargingItemName() == null ? "" : mc.getChargingItemName().toString());
			 String payment_way = DictUtils.getDictLabel(mc.getPaymentWay(), "payment_way", "");
             row.createCell(7).setCellValue(payment_way == null ? "" : payment_way);
			 String formatDate = DateUtils.formatDate(mc.getPaymentTime(), "yyyy-MM-dd HH:mm:ss");
			 row.createCell(8).setCellValue(formatDate == null ? "" : formatDate);
             row.createCell(9).setCellValue(mc.getPaymentRemarks() == null ? "" : mc.getPaymentRemarks().toString());
             row.createCell(10).setCellValue(mc.getUpdateBy().getName() == null ? "" : mc.getUpdateBy().getName().toString());
             // 设置列的样式
             for (Cell cell : row) {cell.setCellStyle(contentStyle);}
             j++;
		}
		if(showChargeItemID.contains(chargingItemID) || showCouponChargeItemID.contains(chargingItemID)){
			HSSFSheet sheet3 = workBook.createSheet("会员中心");
			Row indexRow3 = sheet3.createRow(0);
			indexRow3.createCell(0).setCellValue("序号");
			indexRow3.createCell(1).setCellValue("订单编号");
			sheet3.setColumnWidth(1, 30 * 256);
			indexRow3.createCell(2).setCellValue("付款会员号");
			sheet3.setColumnWidth(2, 15 * 256);
			indexRow3.createCell(3).setCellValue("赛事编号");
			sheet3.setColumnWidth(3, 30 * 256);
			indexRow3.createCell(4).setCellValue("总价");
			sheet3.setColumnWidth(4, 15 * 256);
			indexRow3.createCell(5).setCellValue("支付时间");
			sheet3.setColumnWidth(5, 20 * 256);
			indexRow3.createCell(6).setCellValue("缴费状态");
			sheet3.setColumnWidth(6, 10 * 256);
			for (Cell cell : indexRow3) {
				cell.setCellStyle(indexStyle);
			}
			int k = 1;
			for (Map map : showOrderList) {
				 Row row = sheet3.createRow(k);
				 row.createCell(0).setCellValue(k);
				 row.createCell(1).setCellValue(map.get("orderCode") == null ? "" : map.get("orderCode").toString());
				 row.createCell(2).setCellValue(map.get("paymentMemberCode") == null ? "" : map.get("paymentMemberCode").toString());
				 row.createCell(3).setCellValue(map.get("showCode") == null ? "" : map.get("showCode").toString());
				 row.createCell(4).setCellValue(map.get("orderPrice") == null ? "" : map.get("orderPrice").toString());
				 row.createCell(5).setCellValue(map.get("paymentTime") == null ? "" : map.get("paymentTime").toString());
                 String payState = DictUtils.getDictLabel(map.get("paymentState").toString(), "user_payment_state", "");
                 row.createCell(6).setCellValue(payState == null ? "" : payState.toString());
				 // 设置列的样式
				 for (Cell cell : row) {cell.setCellStyle(contentStyle);}
				 k++;
			}
		}
        OutputStream outputStream = response.getOutputStream();
        workBook.write(outputStream);
        outputStream.close();
		return null;
    }
}
