package com.cku.oa.finance.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.finance.entity.PaymentChargingItemGroup;
import com.cku.oa.finance.service.PaymentChargingItemGroupService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * OA订单录入组合收费项Controller
 *
 * @author 赖广龙
 * @version 2017-06-23
 */
@Controller
@RequestMapping(value = "${adminPath}/finance/paymentChargingItemGroup")
public class PaymentChargingItemGroupController extends BaseController {

	@Autowired
	private PaymentChargingItemGroupService paymentChargingItemGroupService;

	@ModelAttribute
	public PaymentChargingItemGroup get(@RequestParam(required = false) String id) {
		PaymentChargingItemGroup entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = paymentChargingItemGroupService.get(id);
		}
		if (entity == null) {
			entity = new PaymentChargingItemGroup();
		}
		return entity;
	}

	@RequiresPermissions("finance:paymentChargingItemGroup:view")
	@RequestMapping(value = { "list", "" })
	public String list(PaymentChargingItemGroup paymentChargingItemGroup, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Page<PaymentChargingItemGroup> page = paymentChargingItemGroupService
				.findPage(new Page<PaymentChargingItemGroup>(request, response), paymentChargingItemGroup);
		model.addAttribute("page", page);
		return "oa/finance/paymentChargingItemGroupList";
	}

	@RequiresPermissions("finance:paymentChargingItemGroup:view")
	@RequestMapping(value = "form")
	public String form(PaymentChargingItemGroup paymentChargingItemGroup, Model model) {
		model.addAttribute("paymentChargingItemGroup", paymentChargingItemGroup);
		return "oa/finance/paymentChargingItemGroupForm";
	}

	@RequiresPermissions("finance:paymentChargingItemGroup:edit")
	@RequestMapping(value = "save")
	public String save(PaymentChargingItemGroup paymentChargingItemGroup, Model model,
			RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, paymentChargingItemGroup)) {
			return form(paymentChargingItemGroup, model);
		}
		paymentChargingItemGroupService.save(paymentChargingItemGroup);
		addMessage(redirectAttributes, "保存OA订单录入组合收费项成功");
		return "redirect:" + Global.getAdminPath() + "/finance/paymentChargingItemGroup/?repage";
	}

	@RequiresPermissions("finance:paymentChargingItemGroup:edit")
	@RequestMapping(value = "delete")
	public String delete(PaymentChargingItemGroup paymentChargingItemGroup, RedirectAttributes redirectAttributes) {
		paymentChargingItemGroupService.delete(paymentChargingItemGroup);
		addMessage(redirectAttributes, "删除OA订单录入组合收费项成功");
		return "redirect:" + Global.getAdminPath() + "/finance/paymentChargingItemGroup/?repage";
	}

	// @RequiresPermissions("finance:paymentChargingItemGroup:view")
	@RequestMapping(value = { "listFSelect" })
	public String listFSelect(PaymentChargingItemGroup paymentChargingItemGroup, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Page<PaymentChargingItemGroup> page = paymentChargingItemGroupService
				.findPage(new Page<PaymentChargingItemGroup>(request, response), paymentChargingItemGroup);
		model.addAttribute("page", page);
		return "oa/finance/paymentChargingItemGroupList";
	}

}