package com.cku.oa.dog.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogOwnerDao;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogOwner;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.Collections3;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 111Service
 * @author wangjie
 * @version 2018-11-05
 */
@Service
@Transactional(readOnly = true)
public class DogOwnerService extends CrudService<DogOwnerDao, DogOwner> {
	@Autowired
	private  DogOwnerDao dogOwnerDao;
	@Autowired
	private  DogBirthCertificateService dogBirthCertificateService;

	public DogOwner get(String id) {
		return super.get(id);
	}

	public List<DogOwner> findList(DogOwner dogOwner) {
		return super.findList(dogOwner);
	}

	public Page<DogOwner> findPage(Page<DogOwner> page, DogOwner dogOwner) {
		return super.findPage(page, dogOwner);
	}

	@Transactional(readOnly = false)
	public void save(DogOwner dogOwner) {
		super.save(dogOwner);
	}

	@Transactional(readOnly = false)
	public void delete(DogOwner dogOwner) {
		super.delete(dogOwner);
	}

	public DogOwner findByIdentificationFlagAndCabPassport(String identificationFlag, String cabPassport) {
		DogOwner dogOwner = dogOwnerDao.findByIdentificationFlagAndCabPassport(identificationFlag,cabPassport);
		return dogOwner;
	}

	@Transactional(readOnly = false)
	public void saveDogOwner(String identificationFlag, String cabPassport, String petOwnerAddress, String petOwnerMobile, String petOwnerName) {
		List<DogBirthCertificate> list = dogBirthCertificateService.getByIdentificationFlagList(identificationFlag);
		if(Collections3.isEmpty(list)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "找不到该宠物信息");
		}
		DogBirthCertificate dogBirthCertificate = list.get(0);
		if(!cabPassport.equals(dogBirthCertificate.getCabPassport())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号和护照号不匹配");
		}

		DogOwner dow = findByIdentificationFlagAndCabPassport(identificationFlag, cabPassport);
		if(null != dow && dow.getActivateDate() != null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该宠物已经激活");
		}
		DogOwner dogOwner = new DogOwner();
		dogOwner.setCabPassport(cabPassport);
		dogOwner.setActivateDate(new Date());
		dogOwner.setDogOwnerAddress(petOwnerAddress);
		dogOwner.setDogOwnerMobile(petOwnerMobile);
		dogOwner.setDogOwnerName(petOwnerName);
		dogOwner.setIdentificationFlag(identificationFlag);
		super.save(dogOwner);
	}
}