package com.cku.oa.dog.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;
import java.util.List;

/**
 * 视频鉴定Entity
 *
 * @author zxy
 * @version 2020-07-10
 */
public class DogVideoAppraisal extends DataEntity<DogVideoAppraisal> {

	private static final long serialVersionUID = 1L;
	private String clubCode; // 俱乐部code
	private String dogBreed; // 品种
	private String dogBreedCn; // 品种
	private String dogColor; // 毛色
	private String dogColorCn; // 毛色
	private String dogGender; // 性别
	private String dogGenderDesc; // 性别
	private Date dogBirth; // 犬只出生日期
	private String memberCode; // 会员code
	private String memberName; // 会员名
	private String runningNumber; // 订单号
	private String paymentState; // 支付状态
	private Date paymentTime; // 支付时间
	private String reviewState; // 业务状态 0:待审核 1:已审核 2:已驳回 3已注销
	private String reviewRemarks;// 审核原因
	private String dogName;
	private String dogNose;
	private String chipNo;
	private String passportNo;
	private String appraisalNo;
	private String printStatus;
	private String keyword;
	private String source;

	private String memberInfo;
	private String beginCreateDate; // 开始 create_date
	private String endCreateDate; // 结束 create_date

	private Date beginDate;
	private Date endDate;

	private List<DogVideoAppraisalFile> imgs;
	private List<DogVideoAppraisalFile> videos;

	private String vodUrl;

	private String resolveStatus;
	private String appraisalMember;

	private String appraisalDate;
	private String businessRefundState;// 订单状态
	private String orgName;// 订单状态


	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public DogVideoAppraisal() {
		super();
	}

	public DogVideoAppraisal(String id) {
		super(id);
	}

	@Length(min = 0, max = 100, message = "俱乐部code长度必须介于 0 和 100 之间")
	public String getClubCode() {
		return clubCode;
	}

	public void setClubCode(String clubCode) {
		this.clubCode = clubCode;
	}

	@Length(min = 0, max = 64, message = "品种长度必须介于 0 和 64 之间")
	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	@Length(min = 0, max = 32, message = "毛色长度必须介于 0 和 32 之间")
	public String getDogColor() {
		return dogColor;
	}

	public void setDogColor(String dogColor) {
		this.dogColor = dogColor;
	}

	@Length(min = 0, max = 1, message = "性别长度必须介于 0 和 1 之间")
	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	@JsonFormat(pattern = "yyyy-MM-dd")
	public Date getDogBirth() {
		return dogBirth;
	}

	public void setDogBirth(Date dogBirth) {
		this.dogBirth = dogBirth;
	}

	@Length(min = 0, max = 64, message = "会员code长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 32, message = "会员名长度必须介于 0 和 32 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	@Length(min = 0, max = 64, message = "订单号长度必须介于 0 和 64 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	public String getDogBreedCn() {
		return dogBreedCn;
	}

	public void setDogBreedCn(String dogBreedCn) {
		this.dogBreedCn = dogBreedCn;
	}

	public String getDogColorCn() {
		return dogColorCn;
	}

	public void setDogColorCn(String dogColorCn) {
		this.dogColorCn = dogColorCn;
	}

	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}

	public String getDogNose() {
		return dogNose;
	}

	public void setDogNose(String dogNose) {
		this.dogNose = dogNose;
	}

	public String getChipNo() {
		return chipNo;
	}

	public void setChipNo(String chipNo) {
		this.chipNo = chipNo;
	}

	public String getPassportNo() {
		return passportNo;
	}

	public void setPassportNo(String passportNo) {
		this.passportNo = passportNo;
	}

	public String getAppraisalNo() {
		return appraisalNo;
	}

	public void setAppraisalNo(String appraisalNo) {
		this.appraisalNo = appraisalNo;
	}

	public String getPrintStatus() {
		return printStatus;
	}

	public void setPrintStatus(String printStatus) {
		this.printStatus = printStatus;
	}

	public String getKeyword() {
		return keyword;
	}

	public void setKeyword(String keyword) {
		this.keyword = keyword;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public String getMemberInfo() {
		return memberInfo;
	}

	public void setMemberInfo(String memberInfo) {
		this.memberInfo = memberInfo;
	}

	public String getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(String beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public String getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(String endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	public String getDogGenderDesc() {
		return dogGenderDesc;
	}

	public void setDogGenderDesc(String dogGenderDesc) {
		this.dogGenderDesc = dogGenderDesc;
	}

	public List<DogVideoAppraisalFile> getImgs() {
		return imgs;
	}

	public void setImgs(List<DogVideoAppraisalFile> imgs) {
		this.imgs = imgs;
	}

	public List<DogVideoAppraisalFile> getVideos() {
		return videos;
	}

	public void setVideos(List<DogVideoAppraisalFile> videos) {
		this.videos = videos;
	}

	public String getResolveStatus() {
		return resolveStatus;
	}

	public void setResolveStatus(String resolveStatus) {
		this.resolveStatus = resolveStatus;
	}

	public String getAppraisalMember() {
		return appraisalMember;
	}

	public void setAppraisalMember(String appraisalMember) {
		this.appraisalMember = appraisalMember;
	}

	public String getAppraisalDate() {
		return appraisalDate;
	}

	public void setAppraisalDate(String appraisalDate) {
		this.appraisalDate = appraisalDate;
	}

	public Date getBeginDate() {
		return beginDate;
	}

	public void setBeginDate(Date beginDate) {
		this.beginDate = beginDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getVodUrl() {
		return vodUrl;
	}

	public void setVodUrl(String vodUrl) {
		this.vodUrl = vodUrl;
	}

	public String getBusinessRefundState() {
		return businessRefundState;
	}

	public void setBusinessRefundState(String businessRefundState) {
		this.businessRefundState = businessRefundState;
	}

}