/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import java.util.Date;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.dog.entity.DogOwnerChange;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 犬主变更申请DAO接口
 * @author zhuoHeng
 * @version 2016-08-17
 */
@MyBatisDao
public interface DogOwnerChangeDao extends CrudDao<DogOwnerChange> {
	
	int listCount(DogOwnerChange dogOwnerChange);

    void changeStatus(DogOwnerChange dogOwnerChange);

    void edit(DogOwnerChange dogOwnerChange);

    void changeProcessState(DogOwnerChange dogOwnerChange);

    /**
     * 
     * @Description：验证犬只是否存在未处理的犬主变更申请
     * @author: zhuoHeng
     * @version: 2016年10月11日 下午5:18:59
     */
	int validateApply(@Param("dogId") String dogId);
	
	/**
	 * 计算某个犬在某日期后有无犬主变更
	 * @param reviewBeginDate
	 * @param dogId
	 * @return
	 */
	Integer countDogOwnerChangeByReviewTime(@Param("reviewBeginDate") Date reviewBeginDate,@Param("dogId") String dogId);
	
}