/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import com.cku.oa.dog.entity.DogNewborn;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 配种证明DAO接口
 *
 * @author zhuoHeng
 * @version 2016-08-02
 */
@MyBatisDao
public interface DogNewbornDao extends CrudDao<DogNewborn> {

	int listCount(DogNewborn dogNewborn);

	void edit(DogNewborn dogNewborn);

	void changeStatus(DogNewborn dogNewborn);

	DogNewborn getByBreedCertifiedCode(String breedCertifiedCode);

	List<DogNewborn> getBreedNumber(@Param("femalePedigreeCertified") String femalePedigreeCertified);

	String getMaxBreedCertifiedNum(@Param("breedCertifiedNum") String breedCertifiedNum);

	// 根据配种证明号查询父母犬只信息
	DogNewborn getFM(@Param("breedCertifiedCode") String breedCertifiedCode);

	// 查询母犬时间区间内是否有未注销的配种证明记录
	int getByFemalePedigreeCertified(@Param("femalePedigreeCertified") String femalePedigreeCertified,
			@Param("startDay") String startDay, @Param("endDay") String endDay, @Param("id") String id);

	// 查询母犬时间区间内是否有未注销的配种证明记录藏獒
	int getByFemalePedigreeCertifiedZangao(@Param("femalePedigreeCertified") String femalePedigreeCertified,
			@Param("year") String year, @Param("id") String id);

	/**
	 * @description: 根据时间查询未审核记录
	 * @author: laiguanglong
	 * @date: 2017/2/8 12:05
	 */
	List<DogNewborn> findUnReviewByPayDate(@Param("date") Date date);

	/**
	 * @description: 根据母犬血统证书号查询近亲配种记录
	 * @author: laiguanglong
	 * @date: 2017/2/8 12:05
	 */
	List<String> getKinBreedByFemalePedigreeCertified(@Param("femalePedigreeCertified") String femalePedigreeCertified);

	// 根据公犬血统证书号获取有效配种次数
	String getCountByMalePedigreeCertified(@Param("malePedigreeCertified") String malePedigreeCertified);

	// 查询配种证明
	List<DogNewborn> getList(@Param("memberCode") String memberCode,
			@Param("canApplyDogBirthCertificateFlag") String canApplyDogBirthCertificateFlag,
			@Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize,@Param("number") String number);

	// 查询配种证明数量
	long getListCount(@Param("memberCode") String memberCode,
			@Param("canApplyDogBirthCertificateFlag") String canApplyDogBirthCertificateFlag,@Param("number") String number);

	void refundDogNewbornDaoForAll(@Param("ids") Set<String> ids);

	int birthdayCheck(@Param("pedigree_certified") String pedigree_certified);

	int showPaymentCheck(@Param("pedigree_certified") String pedigree_certified);

	List<DogNewborn> getDogBreedList(@Param("pedigreeCertified") String pedigreeCertified);
	
	List<DogNewborn> findAllListByBreedCertifiedCodes(@Param("breedCertifiedCodes") Set<String> breedCertifiedCodes);
}