/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import com.cku.oa.dog.entity.DogAppraisal;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 犬只鉴定表DAO接口
 *
 * @author lgl
 * @version 2016-08-09
 */
@MyBatisDao
public interface DogAppraisalDao extends CrudDao<DogAppraisal> {

    int listCount(DogAppraisal dogAppraisal);

    DogAppraisal getByPedigreeCertified(String pedigreeCertified);
    
    DogAppraisal findById(String id);

    DogAppraisal getByDogId(@Param("dogId") String dogId);

    //根据宠爱证书编号查询犬只鉴定记录
    DogAppraisal getByChongaiCertificateCode(String chongaiCertificateCode);

    //赛场犬只鉴定Count
    int listShowDogAppraisalCount(DogAppraisal dogAppraisal);

    //赛场犬只鉴定列表,delay为赛事报名截至后的天数
    List<DogAppraisal> findShowDogAppraisalList(DogAppraisal dogAppraisal);

    //根据赛事编号查询赛场鉴定报名记录
    List<DogAppraisal> findShowDogAppraisalListByShowCode(@Param("showCode") String showCode);

    //根据id查询赛场鉴定报名记录
    DogAppraisal findShowDogAppraisalById(@Param("id") String id);

    //根据赛事编号获取赛场鉴定编号最大值
    String getMaxShowAppraisalCodeByShowCode(@Param("showCode") String showCode);

    //根据赛场鉴定编号获取赛场鉴定记录
    DogAppraisal getByShowAppraisalCode(@Param("showAppraisalCode") String showAppraisalCode);

    //根据主赛事id获取未删除记录条数
    int countByMainShowId(@Param("mainShowId") String mainShowId);

    DogAppraisal findByDogAppraisal(DogAppraisal dogAppraisal);

    void refunddogAppraisal(@Param("vo") DogAppraisal vo, @Param("ids") List<String> ids);
    
    
    DogAppraisal getbyVideoId(@Param("videoAppraisalId") String videoAppraisalId);
    
    void updateVideoById(@Param("id") String id);
    
    List<DogAppraisal> findDogName(@Param("ids") List<String> ids);
}