/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import com.cku.oa.dog.entity.DogActivation;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 犬只激活DAO接口
 *
 * @author lgl
 * @version 2018-06-12
 */
@MyBatisDao
public interface DogActivationDao extends CrudDao<DogActivation> {
    DogActivation getByBirthCode(@Param("birthCode") String birthCode);

    List<DogActivation> getRemindBirthCode(@Param("dayAfterSend") Integer dayAfterSend,
                                           @Param("date") Date date);

    int autoOffSell();
    int autoStateDown();

    List<DogActivation> search(Map map);

    long getSearchCount(Map map);
}