/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.clubdog.dao;

import org.apache.ibatis.annotations.Param;

import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.cku.oa.clubdog.entity.ClubDog;

/**
 * 淘宠宝犬只信息DAO接口
 * @author cxt
 * @version 2017-10-12
 */
@MyBatisDao
public interface ClubDogDao extends CrudDao<ClubDog> {

	/**
	 * 根据芯片号查询
	 * @Author chaixueteng
	 * @2017年10月17日上午11:03:01
	 */
	ClubDog getByIdentificationFlag(@Param("identificationFlag") String identificationFlag);

	/**
	 * 根据证书号查询
	 * @Author chaixueteng
	 * @2017年10月18日上午10:35:20
	 */
	ClubDog getByPedigreeCertifiedCode(@Param("pedigreeCertifiedCode")String pedigreeCertifiedCode);
	
}