package com.cku.oa.breeder.service;

import com.cku.oa.breeder.dao.BlacklistDao;
import com.cku.oa.breeder.entity.Blacklist;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 黑名单表Service
 *
 * @author lgl
 * @version 2018-01-16
 */
@Service
@Transactional(readOnly = true)
public class BlacklistService extends CrudService<BlacklistDao, Blacklist> {

    public Blacklist get(String id) {
        return super.get(id);
    }

    public List<Blacklist> findList(Blacklist blacklist) {
        return super.findList(blacklist);
    }

    public Page<Blacklist> findPage(Page<Blacklist> page, Blacklist blacklist) {
        return super.findPage(page, blacklist);
    }

    @Transactional(readOnly = false)
    public void save(Blacklist blacklist) {
        super.save(blacklist);
    }

    @Transactional(readOnly = false)
    public void delete(Blacklist blacklist) {
        super.delete(blacklist);
    }

    /**
     * @description: 是否在黑名单，返回true表示在黑名单中
     * @author: laiguanglong
     * @date: 2018/1/16 9:56
     */
    public boolean isInBlacklist(String memberCode, String module) {
        boolean flag = false;
        if (dao.getCount(memberCode, module) > 0) {
            flag = true;
        }
        return flag;
    }
}