package com.cku.oa.appreciation.service;

import java.util.List;
import java.util.Objects;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.appreciation.dao.AppreciationCoursewareDao;
import com.cku.oa.appreciation.entity.AppreciationCourseware;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 鉴赏课Service
 *
 * @author xx
 * @version 2022-02-17
 */
@Service
@Transactional(readOnly = true)
public class AppreciationCoursewareService extends CrudService<AppreciationCoursewareDao, AppreciationCourseware> {

	public AppreciationCourseware get(String id) {
		return super.get(id);
	}

	public List<AppreciationCourseware> findList(AppreciationCourseware appreciationCourseware) {
		return super.findList(appreciationCourseware);
	}

	public Page<AppreciationCourseware> findPage(Page<AppreciationCourseware> page, AppreciationCourseware appreciationCourseware) {
		return super.findPage(page, appreciationCourseware);
	}
	
	public List<AppreciationCourseware> findListByCourseId(String courseId) {
		return dao.findListByCourseId(courseId);
	}

	@Transactional(readOnly = false)
	public void save(AppreciationCourseware appreciationCourseware) {
		super.save(appreciationCourseware);
	}

	@Transactional(readOnly = false)
	public void delete(AppreciationCourseware appreciationCourseware) {
		super.delete(appreciationCourseware);
	}

	/**
	 * 上下架
	 *
	 * @author yuanshuai
	 * @date 2022/2/18 14:53
	 */
	@Transactional(readOnly = false)
	public void onoff(AppreciationCourseware courseware) {
		courseware.setStates("0".equals(courseware.getStates()) ? "1" : "0");
		dao.onoff(courseware);
	}

	/**
	 * 添加课件
	 *
	 * @author yuanshuai
	 * @date 2022/2/18 15:11
	 */
	@Transactional(readOnly = false)
	public void addCourseware(AppreciationCourseware courseware) {
		//默认为上架
		courseware.setStates("1");
		//保存
		save(courseware);
	}

	/**
	 * 添加课件
	 *
	 * @author yuanshuai
	 * @date 2022/2/18 15:11
	 */
	@Transactional(readOnly = false)
	public void addAllCourseware(List<AppreciationCourseware> coursewareList) {
		coursewareList.forEach(courseware -> {
			if (StringUtils.isBlank(courseware.getId())) {
				addCourseware(courseware);
			}else{
				AppreciationCourseware tmp = get(courseware.getId());
				tmp.setCoursewareName(courseware.getCoursewareName());
				tmp.setUrl(courseware.getUrl());
				save(tmp);
			}
		});
	}

	/**
	 * 删除课件
	 *
	 * @author yuanshuai
	 * @date 2022/2/18 15:57
	 */
	@Transactional(readOnly = false)
	public void deleteCourseware(AppreciationCourseware courseware) {
		//已关联课件不可以删除
		if (Objects.nonNull(courseware.getCoursesCount())
				&& courseware.getCoursesCount() > 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "仅可删除未关联课程的课程资料");
		}
		delete(courseware);
	}
}