
package com.cku.oa.appreciation.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

/**
 * 鉴赏课报名Entity
 * 
 * @author zxy
 * @version 2022-02-15
 */
public class AppreciationApply extends DataEntity<AppreciationApply> {

	private static final long serialVersionUID = 1L;
	@ExcelField(title = "报名序号", align = 2, sort = 11)
	private String applyCode; // 报名序号
	
	private String courseId; // 课程ID
	@ExcelField(title = "渠道名称", align = 2, sort = 10)
	private String applyChannel; // 报名渠道
	
	@ExcelField(title = "报名日期", align = 2, sort = 7)
	private Date paymentTime; // 支付时间/报名时间
	
	@ExcelField(title = "缴费状态", align = 2, sort = 8)
	private String paymentState; // 支付状态
	
	@ExcelField(title = "缴费类型", align = 2, sort = 9)
	private String applyType; // 0正常 1试听
	
	private String runningNumber; // 流水号
	
	@ExcelField(title = "会员号", align = 2, sort = 15)
	private String memberCode; // 会员号
	
	@ExcelField(title = "姓名", align = 2, sort = 2)
	private String memberName; // 姓名
	
	@ExcelField(title = "手机号", align = 2, sort = 3)
	private String mobile; // 手机
	
	@ExcelField(title = "门店名称", align = 2, sort = 1)
	private String shopName; // 店名
	
	@ExcelField(title = "省", align = 2, sort = 4)
	private String province; // 省
	
	@ExcelField(title = "市", align = 2, sort = 5)
	private String city; // 城市
	
	@ExcelField(title = "区", align = 2, sort = 6)
	private String area; // 区
	
	@ExcelField(title = "证书号", align = 2, sort = 12)
	private String certificateCode; // 证书编号
	
	private Date issueDate; // 签发日期
	
	@ExcelField(title = "参加课程", align = 2, sort = 13)
	private String courseName; // 课程名称
	@ExcelField(title = "课程状态", align = 2, sort = 14)
	private String courseState; // 课程状态
	
	private String memberKeyword; // 会员查询关键字
	private String memberCardType; // 会员类型
	
	private Date startDate;
	private Date endDate;
	private int maxNum;
	private String applyTypeDesc;
	
	private String num;
	private String arrangeType;
	private Date memberEndDate;
	private int applyNum;
	
	public AppreciationApply() {
		super();
	}

	public AppreciationApply(String id) {
		super(id);
	}

	@Length(min = 0, max = 64, message = "报名序号长度必须介于 0 和 64 之间")
	public String getApplyCode() {
		return applyCode;
	}

	public void setApplyCode(String applyCode) {
		this.applyCode = applyCode;
	}

	@Length(min = 0, max = 50, message = "课程ID长度必须介于 0 和 50 之间")
	public String getCourseId() {
		return courseId;
	}

	public void setCourseId(String courseId) {
		this.courseId = courseId;
	}

	@Length(min = 0, max = 20, message = "报名渠道长度必须介于 0 和 20 之间")
	public String getApplyChannel() {
		return applyChannel;
	}

	public void setApplyChannel(String applyChannel) {
		this.applyChannel = applyChannel;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@Length(min = 0, max = 64, message = "流水号长度必须介于 0 和 64 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 64, message = "会员号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 100, message = "姓名长度必须介于 0 和 100 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	@Length(min = 0, max = 200, message = "手机长度必须介于 0 和 200 之间")
	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	@Length(min = 0, max = 100, message = "店名长度必须介于 0 和 100 之间")
	public String getShopName() {
		return shopName;
	}

	public void setShopName(String shopName) {
		this.shopName = shopName;
	}

	@Length(min = 0, max = 50, message = "省长度必须介于 0 和 50 之间")
	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	@Length(min = 0, max = 50, message = "城市长度必须介于 0 和 50 之间")
	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	@Length(min = 0, max = 50, message = "区长度必须介于 0 和 50 之间")
	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	@Length(min = 0, max = 20, message = "0正常 1试听长度必须介于 0 和 20 之间")
	public String getApplyType() {
		return applyType;
	}

	public void setApplyType(String applyType) {
		this.applyType = applyType;
	}

	@Length(min = 0, max = 64, message = "证书编号长度必须介于 0 和 64 之间")
	public String getCertificateCode() {
		return certificateCode;
	}

	public void setCertificateCode(String certificateCode) {
		this.certificateCode = certificateCode;
	}

	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	public String getCourseName() {
		return courseName;
	}

	public void setCourseName(String courseName) {
		this.courseName = courseName;
	}

	public String getMemberKeyword() {
		return memberKeyword;
	}

	public void setMemberKeyword(String memberKeyword) {
		this.memberKeyword = memberKeyword;
	}

	public String getMemberCardType() {
		return memberCardType;
	}

	public void setMemberCardType(String memberCardType) {
		this.memberCardType = memberCardType;
	}

	public String getCourseState() {
		return courseState;
	}

	public void setCourseState(String courseState) {
		this.courseState = courseState;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public int getMaxNum() {
		return maxNum;
	}

	public void setMaxNum(int maxNum) {
		this.maxNum = maxNum;
	}

	public String getApplyTypeDesc() {
		return applyTypeDesc;
	}

	public void setApplyTypeDesc(String applyTypeDesc) {
		this.applyTypeDesc = applyTypeDesc;
	}

	public String getNum() {
		return num;
	}

	public void setNum(String num) {
		this.num = num;
	}


	public String getArrangeType() {
		return arrangeType;
	}

	public void setArrangeType(String arrangeType) {
		this.arrangeType = arrangeType;
	}

	public Date getMemberEndDate() {
		return memberEndDate;
	}

	public void setMemberEndDate(Date memberEndDate) {
		this.memberEndDate = memberEndDate;
	}

	public int getApplyNum() {
		return applyNum;
	}

	public void setApplyNum(int applyNum) {
		this.applyNum = applyNum;
	}

	public Date getIssueDate() {
		return issueDate;
	}

	public void setIssueDate(Date issueDate) {
		this.issueDate = issueDate;
	}

}