package com.cku.cab.editor.groomervenue.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.cab.editor.groomervenue.entity.GroomerVenue;
import com.cku.cab.editor.groomervenue.service.GroomerVenueService;

/**
 * 美容场馆Controller
 * @author zhuoHeng
 * @version 2016-11-25
 */
@Controller
@RequestMapping(value = "${adminPath}/groomervenue/groomerVenue")
public class GroomerVenueController extends BaseController {

	@Autowired
	private GroomerVenueService groomerVenueService;
	
	@ModelAttribute
	public GroomerVenue get(@RequestParam(required=false) String id) {
		GroomerVenue entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = groomerVenueService.get(id);
		}
		if (entity == null){
			entity = new GroomerVenue();
		}
		return entity;
	}
	
	@RequiresPermissions("groomervenue:groomerVenue:view")
	@RequestMapping(value = {"list", ""})
	public String list(GroomerVenue groomerVenue, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GroomerVenue> page = groomerVenueService.findPage(new Page<GroomerVenue>(request, response), groomerVenue); 
		model.addAttribute("page", page);
		return "editor/groomervenue/groomerVenueList";
	}

	@RequiresPermissions("groomervenue:groomerVenue:view")
	@RequestMapping(value = "form")
	public String form(GroomerVenue groomerVenue, Model model) {
		model.addAttribute("groomerVenue", groomerVenue);
		return "editor/groomervenue/groomerVenueForm";
	}

	@RequiresPermissions("groomervenue:groomerVenue:edit")
	@RequestMapping(value = "save")
	public String save(GroomerVenue groomerVenue, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, groomerVenue)){
			return form(groomerVenue, model);
		}
		groomerVenueService.save(groomerVenue);
		addMessage(redirectAttributes, "保存美容场馆成功");
		return "redirect:"+Global.getAdminPath()+"/groomervenue/groomerVenue/?repage";
	}
	
	@RequiresPermissions("groomervenue:groomerVenue:edit")
	@RequestMapping(value = "delete")
	public String delete(GroomerVenue groomerVenue, RedirectAttributes redirectAttributes) {
		groomerVenueService.delete(groomerVenue);
		addMessage(redirectAttributes, "删除美容场馆成功");
		return "redirect:"+Global.getAdminPath()+"/groomervenue/groomerVenue/?repage";
	}
	
	

}