package com.cku.cab.editor.ckuhotel.service;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.cab.editor.ckuhotel.entity.CkuHotel;
import com.cku.cab.editor.ckuhotel.entity.RestCkuHotel;
import com.cku.cab.editor.handlervenue.entity.HandlerVenue;
import com.cku.cab.editor.handlervenue.entity.RestfulHandlerVenue;
import com.cku.core.RESTResponse;
import com.cku.restful.v1.groomer.model.RestGroomerShow;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.cab.editor.ckuhotel.dao.CkuHotelDao;

/**
 * 美容培训酒店Service
 * @author zhuoHeng
 * @version 2016-11-29
 */
@Service
@Transactional(readOnly = true)
public class CkuHotelService extends CrudService<CkuHotelDao, CkuHotel> {

	public CkuHotel get(String id) {
		return super.get(id);
	}
	
	public List<CkuHotel> findList(CkuHotel ckuHotel) {
		return super.findList(ckuHotel);
	}
	
	public Page<CkuHotel> findPage(Page<CkuHotel> page, CkuHotel ckuHotel) {
		return super.findPage(page, ckuHotel);
	}
	
	@Transactional(readOnly = false)
	public void save(CkuHotel ckuHotel) {
		super.save(ckuHotel);
	}
	
	@Transactional(readOnly = false)
	public void delete(CkuHotel ckuHotel) {
		super.delete(ckuHotel);
	}

	public RESTResponse getHotel(HttpServletRequest request) {
		String id = request.getParameter("id");
		String[] ids = id.split(",");
		StringBuffer sb = new StringBuffer();
		for (String i : ids) {
			sb.append("'");
			sb.append(i);
			sb.append("',");
		}
		id = sb.substring(0, sb.length()-1);
		CkuHotel ckuHotel = new CkuHotel();
		ckuHotel.setId(id);
		List<CkuHotel> model = super.findList(ckuHotel);
		List<RestCkuHotel> list = new ArrayList<RestCkuHotel>();
		for (CkuHotel hotel : model) {
			RestCkuHotel vo = new RestCkuHotel();
			BeanUtil.copyProperties(vo, hotel, "yyyy-MM-dd");
			list.add(vo);
		}
		
		return new RESTResponse("list", list);
	}
	
}