package com.cku.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.dao.IpAddressMapper;
import com.cku.model.IpAddress;
import com.cku.util.DateUtils;

/**
 * ip映射表Service
 * @author ip映射表
 * @version 2019-10-18
 */
@Service
@Transactional(readOnly = true)
public class IpAddressServiceImpl {

	@Autowired
	private IpAddressMapper ipAddressDao;
	
	@Transactional(readOnly = false)
	public void addIpAddress(String ip) {
		IpAddress ipAddress = new IpAddress();
		ipAddress.setIp(ip);
		ipAddress.setToday(DateUtils.getDate());
		IpAddress result = this.findByParam(ipAddress);
		if (result == null) {
//			ipAddress.setId();
			ipAddress.setCount(1);
			this.insertIpAddress(ipAddress);
		} else {
			this.updateByParam(ipAddress);
		}
	}

	@Transactional(readOnly = false)
	public void insertIpAddress(IpAddress ipAddress) {
		ipAddressDao.insert(ipAddress);
	}

	public IpAddress findByParam(IpAddress ipAddress) {
		return ipAddressDao.findByParam(ipAddress);
	}

	@Transactional(readOnly = false)
	public void updateByParam(IpAddress ipAddress) {
		ipAddressDao.updateByParam(ipAddress);
	}

	public boolean isBlackList(String ip) {
		return !CollectionUtils.isEmpty(ipAddressDao.findIpBlackList(ip));
	}
	
}