package com.cku.controller;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cab.service.UserService;
import com.cku.core.RESTResponse;
import com.cku.model.CkuMemberBalance;
import com.cku.model.CkuUserPayList;
import com.cku.service.CkuMemberBalanceServiceImpl;
import com.cku.util.PageBean;
import com.cku.util.ServletUtils;

@Controller
@RequestMapping("cku")
public class CkuMemberLoginController {

	@Autowired
	public CkuMemberBalanceServiceImpl ckuMemberBalanceService;

	/**
	 *
	 * @Description：查询CKU会员账户余额
	 * @author: zhuoHeng
	 * @version: 2016年4月14日 上午10:07:16
	 */
	@RequestMapping("/ckuBalance")
	public void getCkuMemberBalance(HttpServletResponse response,HttpServletRequest request) throws IOException{
		RESTResponse result = null;
		try
		{
			String userId = UserService.verifyThirdUserId(request);
			CkuMemberBalance obj = ckuMemberBalanceService.getCkuMemberBalance(userId);
			result = new RESTResponse("item", obj);
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}

		ServletUtils.writeResponse(response, result);
	}


	/**
	 *
	 * @Description：查询CKU会员我的账户余额收支详情
	 * @author: zhuoHeng
	 * @version: 2016年4月14日 下午3:46:53
	 */
	@RequestMapping("/getCkuBalanceInfo")
	public void getCkuBalanceInfo(HttpServletResponse response,HttpServletRequest request) throws IOException{
		RESTResponse result = null;
		try
		{
			String userId = UserService.verifyThirdUserId(request);
			PageBean pageBean = ServletUtils.getParameterBean(request);
			String flag = ServletUtils.getParameter(request, "flag","all");
			List<CkuUserPayList> obj = ckuMemberBalanceService.getCkuBalanceInfo(userId,pageBean,flag);
			result = new RESTResponse("item", obj);
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}

		ServletUtils.writeResponse(response, result);
	}

}
