package com.cab.controller;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cab.model.CabMymessage;
import com.cab.service.CabMymessageServiceImpl;
import com.cab.service.UserService;
import com.cku.core.RESTResponse;
import com.cku.util.ServletUtils;

@Controller
@RequestMapping("mymessage")
public class CabMymessageController {
	@Autowired
	public CabMymessageServiceImpl cabMymessageService;

	/**
	 * 得到我的消息列表 --lyy
	 * 
	 * @param response
	 * @param request
	 * @param userId
	 * @throws IOException
	 */
	@RequestMapping("/getMymessageCount")
	public void getMymessageCount(HttpServletResponse response, HttpServletRequest request) throws IOException {
		RESTResponse result = null;
		try {
			String userId = UserService.verifyUserId(request);
			String isRead = ServletUtils.getParameter(request, "isRead", "all");
			List<CabMymessage> item = cabMymessageService.getMymessageCount(userId, isRead);
			//String p = request.getParameter(isRead);
			//未读没数据时取所有最新的一条
			if ("no".equals(isRead) && item.size()==0){
				List<CabMymessage> items = cabMymessageService.getMymessageCount(userId, "all");
				if(items.size()>0){
					CabMymessage cabMymessage = new CabMymessage();
					cabMymessage.setType(items.get(0).getType());
					cabMymessage.setTypeCount(0);
					cabMymessage.setContent(items.get(0).getContent());
					cabMymessage.setCreateTime(items.get(0).getCreateTime());
					item.add(cabMymessage);
				}
			}
			result = new RESTResponse("items", item);
		} catch (Exception e) {
			result = new RESTResponse(e);
		}

		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 得到某类型下的消息 --lyy
	 * 
	 * @param response
	 * @param request
	 * @param userId
	 * @throws IOException
	 */
	@RequestMapping("/getMymessageByType")
	public void getMymessageByType(HttpServletResponse response, HttpServletRequest request) throws IOException {
		RESTResponse result = null;
		try {
			String userId = UserService.verifyUserId(request);
			Integer type = ServletUtils.getParameterInt(request, "type");
			String isRead = ServletUtils.getParameter(request, "isRead", "all");
			List<CabMymessage> item = cabMymessageService.getMymessageByType(userId, type, isRead);
			result = new RESTResponse("items", item);
			//将消息标记为已读
			for(CabMymessage mymessage : item){
				cabMymessageService.updateIsRead(mymessage.getId());
			}
		} catch (Exception e) {
			result = new RESTResponse(e);
		}

		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 根据id得到消息信息 --lyy
	 * 
	 * @param response
	 * @param request
	 * @param userId
	 * @throws IOException
	 */
	@RequestMapping("/getMymessageById")
	public void getMymessageById(HttpServletResponse response, HttpServletRequest request) throws IOException {
		RESTResponse result = null;
		try {
			Integer id = ServletUtils.getParameterInt(request, "id");
			CabMymessage item = cabMymessageService.getMymessageById(id);
			result = new RESTResponse("items", item);
		} catch (Exception e) {
			result = new RESTResponse(e);
		}

		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 根据id将消息标记为已读 --lyy
	 * 
	 * @param response
	 * @param request
	 * @param userId
	 * @throws IOException
	 */
	@RequestMapping("/updateIsRead")
	public void updateIsRead(HttpServletResponse response, HttpServletRequest request) throws IOException {
		RESTResponse result = null;
		try {
			Integer id = ServletUtils.getParameterInt(request, "id");
			int item = cabMymessageService.updateIsRead(id);
			result = new RESTResponse("items", item);
		} catch (Exception e) {
			result = new RESTResponse(e);
		}

		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 根据id将消息标记为已读 --lyy
	 * 
	 * @param response
	 * @param request
	 * @param userId
	 * @throws IOException
	 */
	@RequestMapping("/updateAllIsRead")
	public void updateAllIsRead(HttpServletResponse response, HttpServletRequest request) throws IOException {
		RESTResponse result = null;
		try {
			String userId = UserService.verifyUserId(request);
			int item = cabMymessageService.updateAllIsRead(userId);
			result = new RESTResponse("items", item);
		} catch (Exception e) {
			result = new RESTResponse(e);
		}

		ServletUtils.writeResponse(response, result);
	}
}
