package com.cku.service;


import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cku.core.ExecResultModel;
import com.cku.dao.CkuDvUserMapper;
import com.cku.dao.CkuUserMapper;
import com.cku.dao.SPOrderInfoMapper;
import com.cku.model.CkuDvUserModel;
import com.cku.model.CkuMatchSign;


@Service("ckuMatchSignService")
public class CkuMatchSignServiceImpl {
	@Autowired
	public SPOrderInfoMapper sPOrderInfoMapper;
	
	@Autowired
	public CkuDvUserMapper ckuDvUserMapper;
	
	@Autowired
	public CkuUserMapper ckuUserMapper;
	
	@Autowired
	public PublicService publicService;
	
	public Map checkSignUnfinished(String thirdUserId){
		String ckuId = "-1";
		Map<String,String> map = new HashMap<String,String>();
		//根据CKU账号id查询出CKU账号信息
		CkuDvUserModel ckuDvUserModel = ckuDvUserMapper.getckuMemberByUserId(thirdUserId);
		if(ckuDvUserModel != null){
			ckuId = ckuDvUserModel.getCkuId();
		}
		int i=sPOrderInfoMapper.checkSignUnfinished(ckuId);
		//是否有未支付订单
		map.put("order", i>0?"yes":"no");
		//List<CkuUser> eventIntroduce = ckuUserMapper.getUserMessage(ckuId);
		//是否是新会员
		//map.put("newVip", eventIntroduce!=null&&"0".equals(eventIntroduce.get(0).getIsnewuser())?"yes":"no");
		map.put("newVip", "no");
		boolean flag = publicService.memberStatus(ckuId);
		//会员是否有效
		map.put("rightVip", flag?"yes":"no");
		return map;
	}
	
	public String addSign(String userNo,String dogId,String trainId,Long matchId,Long projectId){
		ExecResultModel<CkuMatchSign> resultModel = new ExecResultModel<CkuMatchSign>();
		//ckuMatchSignMapper.insertSelective(record);
		
		resultModel.setItems(null);
		resultModel.setTotal((long) 0);
		resultModel.setRc(0);
		return resultModel.getToJson();
	}

}
