package com.cku.controller;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.core.ZAException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cab.service.UserService;
import com.cku.core.RESTResponse;
import com.cku.service.DogRelatedServiceImpl;
import com.cku.util.PageBean;
import com.cku.util.ServletUtils;

/**
 * 
 * <p>Title:DogRelatedController </p>
 * <p>Description: 与犬类相关的接口</p>
 * <p>Company: </p> 
 * @author zhuoHeng
 * @date 2016年3月16日 下午4:38:13
 */
@Controller
@RequestMapping(value="dogRelated")
public class DogRelatedController {

	private static final Logger logger = Logger.getLogger(EventRelatedController.class);
	
	@Autowired
	public DogRelatedServiceImpl dogRelatedServiceImpl;
	/**
	 * 
	 * @Description：根据cku证书号/犬只芯片号获取犬信息（带校验）
	 * @author: zhuoHeng
	 * @version: 2016年3月16日 下午5:08:32
	 */
	@RequestMapping(value = "/getDogMessage")
	public void getDogMessage(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "pedigreeNum", required = false)String pedigreeNum,
			@RequestParam(value = "dogId", required = false)String dogId,
			@RequestParam(value = "showNums", required = false)String showNums){
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = dogRelatedServiceImpl.getEventList(pedigreeNum,dogId,showNums);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
	/**
	 * 
	 * @Description：根据犬只cku证书号查询上3代犬只信息
	 * @author: zhuoHeng
	 * @version: 2016年3月24日 下午3:27:00
	 * @throws IOException 
	 */
	@RequestMapping(value = "/getDogFamily")
	public void getDogFamily(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "pedigreeNum", required = false)String pedigreeNum,
			@RequestParam(value = "dogId", required = false)String dogId) throws IOException{
		RESTResponse result = null;
		try
		{
			Map str = dogRelatedServiceImpl.getDogFamily(pedigreeNum,dogId);
			result = new RESTResponse("items",str);
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}
		
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 
	 * @Description：根据cku证书号/犬只芯片号获取犬信息（无校验）
	 * @author: zhuoHeng
	 * @version: 2016年3月24日 下午3:30:31
	 */
	@RequestMapping(value = "/getDogMessageForIndex")
	public void getDogMessageForIndex(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "pedigreeNum", required = false)String pedigreeNum,
			@RequestParam(value = "dogId", required = false)String dogId) throws IOException {
//		try {
//			UserService.verifyThirdUserId(request);
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = dogRelatedServiceImpl.getDogMessageForIndex(pedigreeNum,dogId);
			response.getWriter().write(str);
//		} catch (Exception e) {
//			logger.error(e.getMessage());
//			if (10001 == ((ZAException) e).get_code()) {
//				ServletUtils.writeResponse(response, new RESTResponse(10001, "请登录后查询"));
//			}
//		}
	}
	/**
	 * 
	 * @Description：根据cku证书号查询犬只（全犬种）比赛结果
	 * @author: zhuoHeng
	 * @version: 2016年3月24日 下午5:14:17
	 */
	@RequestMapping(value = "/getDogGradeList")
	public void getDogGradeList(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "pedigreeNum", required = false)String pedigreeNum,
			@RequestParam(value = "charTime", required = false)String charTime){
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = dogRelatedServiceImpl.getDogGradeList(pedigreeNum,charTime);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
	/**
	 * 
	 * @Description：根据cku证书号查询犬只（单独展）比赛结果
	 * @author: zhuoHeng
	 * @version: 2016年3月24日 下午6:00:28
	 */
	@RequestMapping(value = "/getDogGradeDdzList")
	public void getDogGradeDdzList(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "pedigreeNum", required = false)String pedigreeNum,
			@RequestParam(value = "charTime", required = false)String charTime){
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = dogRelatedServiceImpl.getDogGradeDdzList(pedigreeNum,charTime);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
	/**
	 * 
	 * @Description：冠军登录犬只信息查询（犬只冠军登录申请资格校验）
	 * @author: zhuoHeng
	 * @version: 2016年4月6日 上午9:50:35
	 */
	@RequestMapping(value = "/getDogMessageByLoginUser")
	public void getDogMessageByLoginUser(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "userNum",required = false)String userNum,
			@RequestParam(value = "pedigreeNum",required = false)String pedigreeNum){
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = dogRelatedServiceImpl.getDogMessageByLoginUser(userNum,pedigreeNum);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
	/**
	 * 
	 * @Description：获取登录会员的CKU犬只列表
	 * @author: zhuoHeng
	 * @version: 2016年4月6日 下午6:24:04
	 */
	@RequestMapping(value = "/getDogListByLoginUser")
	public void getDogListByLoginUser(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "userNum",required = false)String userNum){
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			PageBean pb = ServletUtils.getParameterBean(request);
			String str = dogRelatedServiceImpl.getDogListByLoginUser(userNum,pb);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
	
}
