package com.sys.service;

import com.sys.dao.CKUOauth2ClientMapper;
import com.sys.dao.Oauth2ClientMapper;
import com.sys.model.CKUOauth2Client;
import com.sys.model.Oauth2Client;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

@Service("ckuOauth2ClientService")
public class CKUOauth2ClientServiceImpl {
	private Cache cache;
	@Autowired
	public CKUOauth2ClientMapper ckuOauth2ClientMapper;

	@Autowired
	public CKUOauth2ClientServiceImpl(CacheManager cacheManager) {
		this.cache = cacheManager.getCache("cku-cache");
	}

	public int deleteByPrimaryKey(Long id) {
		return ckuOauth2ClientMapper.deleteByPrimaryKey(id);
	}

	public int insert(CKUOauth2Client record) {
		return ckuOauth2ClientMapper.insert(record);
	}

	public int insertSelective(CKUOauth2Client record) {
		return ckuOauth2ClientMapper.insertSelective(record);
	}

	public CKUOauth2Client selectByPrimaryKey(Long id) {
		return ckuOauth2ClientMapper.selectByPrimaryKey(id);
	}

	public int updateByPrimaryKeySelective(CKUOauth2Client record) {
		return ckuOauth2ClientMapper.updateByPrimaryKeySelective(record);
	}
	public boolean checkClientIdExist(String clientId){
		return this.selectByClientId(clientId)==null?false:true;
	}
	public CKUOauth2Client selectByClientId(String clientId){
		return ckuOauth2ClientMapper.selectByClientId(clientId);
	}
	public boolean checkClientSecretExist(String clientSecret){
		return this.selectByClientSecret(clientSecret)==null?false:true;
	}
	public CKUOauth2Client selectByClientSecret(String clientSecret){
		return ckuOauth2ClientMapper.selectByClientSecret(clientSecret);
	}
	public int updateByPrimaryKey(CKUOauth2Client record) {
		return ckuOauth2ClientMapper.updateByPrimaryKey(record);
	}

	public void addAuthCode(String oauthCode,String userInfo){
			cache.put(oauthCode,userInfo);
	}
	public String getAuthCode(String oauthCode){
		return (String)cache.get(oauthCode).get();
	}
	public boolean checkAuthCode(String oauthCode){
		return cache.get(oauthCode)!=null;
	}
	public void addAccessToken(String accessToken,String userInfo){
		cache.put(accessToken,userInfo);
	}
	public boolean checkAccessToken(String accessToken){
		return cache.get(accessToken) != null;
	}
	public String getAccessToken(String accessToken){
		return (String)cache.get(accessToken).get();
	}
	public long getExpireIn() {
		return 7200L;
	}
}
