package com.cku.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cku.core.PageBeanResult;
import com.cku.dao.BirthCertificateMapper;
import com.cku.model.BirthCertificate;
import com.cku.util.PageBean;

@Service("birthCertificateService")
public class BirthCertificateServiceImpl {
    
    @Autowired
    public BirthCertificateMapper BirthCertificateMapper;

    
    /**
     * 
     * @Description：根据出生纸编号查询出生纸信息
     * @author: zhuoHeng
     * @version: 2016年7月27日 上午10:19:39
     */
    public BirthCertificate getBirthCertificate(String birthCertificateCode){
        BirthCertificate data = BirthCertificateMapper.getBirthCertificate(birthCertificateCode);
        return data;
    }
    
    /**
     * 
     * @Description：分页查询某会员拥有的所有出生纸信息/分页查询某配种编号下所有出生纸信息
     * @author: zhuoHeng
     * @version: 2016年7月27日 下午12:07:15
     */
    public PageBeanResult<BirthCertificate> getBirthCertificateByMemberNum(String MemberNum,String breedCertifiedNum,PageBean pb){
        PageBeanResult<BirthCertificate> pbr=new PageBeanResult<BirthCertificate>();
        long start = pb.get_start();
        long count = pb.get_limit();
        List<BirthCertificate> list = BirthCertificateMapper.getBirthCertificateByMemberNum(MemberNum,breedCertifiedNum,start,count);
        pbr.list = list;
        return pbr;
    }
}
