package com.cku.service;


import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cku.core.ExecResultModel;
import com.cku.dao.CkuDvUserMapper;
import com.cku.dao.CkuUserMapper;
import com.cku.dao.FrequentlyUsedUsersMapper;
import com.cku.model.CkuDvUserModel;
import com.cku.model.CkuUser;
import com.cku.model.FrequentlyUsersModel;
/**
 * 
 * <p>Title:UserRelatedServiceImpl </p>
 * <p>Description: 用户相关服务类</p>
 * <p>Company: </p> 
 * @author zhuoHeng
 * @date 2016年3月17日 上午9:18:04
 */
@Service("userRelatedServiceImpl")
public class UserRelatedServiceImpl{
	@Autowired
	public CkuDvUserMapper ckuDvUserMapper;
	
	@Autowired
	public CkuUserMapper ckuUserMapper;
	
	@Autowired
	public PublicService publicService;
	
	@Autowired
	public FrequentlyUsedUsersMapper frequentlyUsedUsersMapper;
	
	/**
	 * 
	 * @Description：根据牵犬师会员号获取会员信息
	 * @author: zhuoHeng
	 * @version: 2016年3月17日 上午9:26:45
	 */
	public String getUserMessage(String idNum){
		
		ExecResultModel<CkuUser> resultModel = new ExecResultModel<CkuUser>();
		List<CkuUser> eventIntroduce = ckuUserMapper.getUserMessage(idNum);
		if(eventIntroduce.size()>0){
			boolean flag = publicService.memberStatus(idNum);
			boolean suspendFlag = publicService.suspendStatus(idNum);
			if(flag&&suspendFlag){
				resultModel.setItems(eventIntroduce);
				resultModel.setRc(0);
				resultModel.setTotal((long)eventIntroduce.size());
				resultModel.setMsg("");
			} else{
				if(flag){
					resultModel.setRc(105);
					resultModel.setItems(new ArrayList<CkuUser>());
					resultModel.setMsg("会员在禁止报名期");
				}else if(suspendFlag){
					resultModel.setRc(106);
					resultModel.setItems(new ArrayList<CkuUser>());
					resultModel.setMsg("会员资格失效");
				}
			}
		}else{
			resultModel.setItems(new ArrayList<CkuUser>());
			resultModel.setRc(1);
			resultModel.setTotal((long)eventIntroduce.size());
			resultModel.setMsg("无对应数据");
		}
		
		
		return resultModel.getToJson();
	}
	/**
	 * 
	 * @Description：根据登录者会员号获取登录会员的常用牵犬师
	 * @author: zhuoHeng
	 * @version: 2016年3月17日 上午10:44:59
	 */
	public String getFrequentlyUsedUsers(String idNum){
		
		ExecResultModel<FrequentlyUsersModel> resultModel = new ExecResultModel<FrequentlyUsersModel>();
		List<FrequentlyUsersModel> eventIntroduce = frequentlyUsedUsersMapper.getFrequentlyUsedUsers(idNum);
		resultModel.setItems(eventIntroduce);
		resultModel.setRc(0);
		resultModel.setMsg("");
		resultModel.setTotal((long)eventIntroduce.size());
		return resultModel.getToJson();
	}
	/**
	 * 
	 * @Description：保存常用牵犬师
	 * @author: zhuoHeng
	 * @version: 2016年3月17日 上午11:04:11
	 */
	public String saveFrequentlyUsedUser(String idNum,String login_user_num,String user_name,String mobile_phone){
		
		ExecResultModel<String> resultModel = new ExecResultModel<String>();
		try {
			List<FrequentlyUsersModel> eventIntroduce = frequentlyUsedUsersMapper.getFrequentlyUsedUsers(login_user_num);
			for (int i = 0; i < eventIntroduce.size(); i++) {
				if(eventIntroduce.get(i).getId_num().equals(idNum)){
					resultModel.setItems(new ArrayList<String>());
					resultModel.setRc(0);
					resultModel.setMsg("");
					return resultModel.getToJson();
				}
			}
			frequentlyUsedUsersMapper.saveFrequentlyUsedUser(idNum,login_user_num,user_name,mobile_phone);
			resultModel.setItems(new ArrayList<String>());
			resultModel.setRc(0);
			resultModel.setMsg("");
		} catch (Exception e) {
			resultModel.setRc(1);
			resultModel.setItems(new ArrayList<String>());
			resultModel.setMsg("fail");
		}
		return resultModel.getToJson();
	}
	/**
	 * 
	 * @Description：判断用户是否为新会员
	 * @author: zhuoHeng
	 * @version: 2016年3月17日 下午7:38:49
	 */
	public String newVipStatus(String thirdUserId){
		String ckuId = "-1";
		//根据CKU账号id查询出CKU账号信息
		CkuDvUserModel ckuDvUserModel = ckuDvUserMapper.getckuMemberByUserId(thirdUserId);
		if(ckuDvUserModel != null){
			ckuId = ckuDvUserModel.getCkuId();
		}
		List<CkuUser> eventIntroduce = ckuUserMapper.getUserMessage(ckuId);
		String isnewuser = eventIntroduce.get(0).getIsnewuser();
		return isnewuser;
	}
	/**
	 * 
	 * @Description：根据会员号查询常用牵犬师详细
	 * @author: zhuoHeng
	 * @version: 2016年3月18日 上午9:15:59
	 */
	public String getFrequentlyUsedUserInfo(String idNum,String loginUserNum){
		
		ExecResultModel<FrequentlyUsersModel> resultModel = new ExecResultModel<FrequentlyUsersModel>();
		List<FrequentlyUsersModel> eventIntroduce = frequentlyUsedUsersMapper.getFrequentlyUsedUserInfo(idNum,loginUserNum);
		resultModel.setItems(eventIntroduce);
		resultModel.setRc(0);
		resultModel.setMsg("");
		resultModel.setTotal((long)eventIntroduce.size());
		return resultModel.getToJson();
	}
	
	
}
