package com.cku.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.dao.CkuDvUserMapper;
import com.cku.dao.CkuMemberBalanMapper;
import com.cku.dao.CkuUserPayListMapper;
import com.cku.model.CkuDvUserModel;
import com.cku.model.CkuMemberBalance;
import com.cku.model.CkuUserPayList;
import com.cku.util.Debugger;
import com.cku.util.PageBean;

@Service("ckuMemberBalanceService")
public class CkuMemberBalanceServiceImpl {
	
	@Autowired
	public CkuMemberBalanMapper ckuMemberBalanMapper;
	
	@Autowired
	public CkuDvUserMapper ckuDvUserMapper;
	
	@Autowired
	public CkuUserPayListMapper ckuUserPayListMapper;

	/**
	 * 
	 * @Description：查询CKU会员账户余额
	 * @author: zhuoHeng
	 * @version: 2016年4月14日 上午10:26:50
	 */
	public CkuMemberBalance getCkuMemberBalance(String thirdUserId){
		
		String ckuUserId = "-1";
		//根据CKU账号id查询出CKU账号信息
		CkuDvUserModel ckuDvUserModel = ckuDvUserMapper.getckuMemberByUserId(thirdUserId);
		if(ckuDvUserModel != null){
			ckuUserId = ckuDvUserModel.getCkuId();
		}
		//根据CKU会员号查询出对应用户的余额信息
		CkuMemberBalance ckuMemberBalance = ckuMemberBalanMapper.getCkuMemberBalance(ckuUserId);
		
		if(ckuMemberBalance==null){
			ckuMemberBalance = new CkuMemberBalance();
			String str = "0.00";
			ckuMemberBalance.setMoneyAmount(str);
		}
		
		return ckuMemberBalance;
	}
	
	/**
	 * 
	 * @Description：查询CKU会员我的账户余额收支详情
	 * @author: zhuoHeng
	 * @version: 2016年4月14日 下午3:32:28
	 * @throws ZAException 
	 */
	public List<CkuUserPayList> getCkuBalanceInfo(String thirdUserId,PageBean pageBean,String flag) throws ZAException{
		String ckuUserId = "";
		Debugger.doAssert(("in".equals(flag)||"out".equals(flag)||"all".equals(flag)), ZAErrorCode.ZA_ERC_UNKNOWN, "无效参数");
		//根据CKU账号id查询出CKU账号信息
		CkuDvUserModel ckuDvUserModel = ckuDvUserMapper.getckuMemberByUserId(thirdUserId);
		if(ckuDvUserModel != null){
			ckuUserId = ckuDvUserModel.getCkuId();
		}
		//根据CKU会员号查询出对应用户的余额支付详情
		List<CkuUserPayList> ckuUserPayList = ckuUserPayListMapper.getCkuBalanceInfo(ckuUserId,pageBean.get_limit(),pageBean.get_start(),flag);
		
		return ckuUserPayList;
	}
}
