package com.cku.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.model.CkuDogScoreModel;
import com.cku.model.CkuMatchSign;
import com.cku.model.CkuTabGrade;
import com.cku.model.CkuTabGradeWithBLOBs;

public interface CkuTabGradeMapper {
    int deleteByPrimaryKey(Integer id);

    int insert(CkuTabGradeWithBLOBs record);

    int insertSelective(CkuTabGradeWithBLOBs record);

    CkuTabGradeWithBLOBs selectByPrimaryKey(Integer id);

    int updateByPrimaryKeySelective(CkuTabGradeWithBLOBs record);

    int updateByPrimaryKeyWithBLOBs(CkuTabGradeWithBLOBs record);

    int updateByPrimaryKey(CkuTabGrade record);
    
    /**
     * 已改
     * @Description：根据血统证书号和时间参数（年月）查询该年月下该证书号的全犬种成绩
     * @author: zhuoHeng
     * @version: 2016年9月10日 下午12:14:05
     */
    public List<CkuTabGrade> getDogGradeList(@Param("pedigreeNum")String pedigreeNum,@Param("charTime")String charTime);
    
    /**
     * 已改
     * @Description：根据血统证书号获取犬只存在全犬种成绩所在的月份
     * @author: zhuoHeng
     * @version: 2016年9月10日 下午12:11:30
     */
    public List<CkuTabGrade> getDogGradeMonth(@Param("pedigreeNum")String pedigreeNum);
    
    /**
     * 已改
     * @Description：根据赛事编号和血统证书号查询犬只成绩
     * @author: zhuoHeng
     * @version: 2016年9月10日 上午11:22:24
     */
    public List<CkuTabGrade> getGradeListByShowsNum(@Param("studbookNum") String studbookNum,@Param("showNumsQqz") String showNumsQqz,@Param("showNumsDdz") String showNumsDdz);
    /**
     * 
     * @Description：根据犬只CKU证书号查询全犬种成绩汇总
     * @author: zhuoHeng
     * @version: 2016年4月12日 下午3:36:36
     */
    public CkuDogScoreModel getDogScore(@Param("studbookNum") String studbookNum);
}