package com.cku.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSONObject;
import com.cku.util.*;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.model.CkuImage;
import com.cku.model.CkuMatchVenue;
import com.cku.service.CkuImageServiceImpl;
import com.cku.service.CkuMatchVenueServiceImpl;

@Controller
@RequestMapping(value="ckuMatchVenue")
public class CkuMatchVenueController {
	private static final Logger logger = Logger.getLogger(CkuMatchVenueController.class);
	@Autowired
	public CkuMatchVenueServiceImpl ckuMatchVenueSerivce;

	//得到所有接口
	@RequestMapping(value="/getVenue")
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void getVenue(@RequestParam(value = "showLocation", required = false)String showLocation,
			HttpServletResponse response,HttpServletRequest request) {
		try {
			//showLocation =new String(showLocation.getBytes("ISO-8859-1"),"UTF-8");//字符转换 
			System.out.println("test--------------");
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String result = ckuMatchVenueSerivce.getVenue(showLocation);
		    response.getWriter().write(result);
		} catch (Exception e) {
			// TODO: handle exception
			logger.error(e);
		}
	}
	
	//得到ModalList
	@RequestMapping(value="/getListModal")
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void getListModal(HttpServletResponse response,HttpServletRequest request) throws IOException {
		RESTResponse result = null;
		try{
			String name = ServletUtils.getParameter(request, "name",null);
			PageBean pb = ServletUtils.getParameterBean(request);
			PageBeanResult<CkuMatchVenue> list = ckuMatchVenueSerivce.getList(name,null,pb);
			result = new RESTResponse("items", list);
		}catch (Exception e){
			result = new RESTResponse(e);
			logger.error(e);
		}
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 
	 */
	@RequestMapping(value="/getList")
	public ModelAndView getList(HttpServletResponse response,HttpServletRequest request,ModelMap modelMap) throws IOException {
		String venueName = ServletUtils.getParameter(request, "venueName",null);
		String venueAddress = ServletUtils.getParameter(request, "venueAddress",null);
		PageBean pb = ServletUtils.getParameterBean(request);
		PageBeanResult<CkuMatchVenue> s = ckuMatchVenueSerivce.getList(venueName,venueAddress,pb);
		modelMap.addAttribute("pageList",s);
		ModelAndView mv = new ModelAndView("admin/ckuMatchVenue/matchVenueList",modelMap);
		return mv;
	
	}
	/**
	 * 
	 */
	@RequestMapping(value="/toUpdate")
	public ModelAndView toUpdate(HttpServletResponse response,HttpServletRequest request, ModelMap modelMap) throws IOException{
		 String type = ServletUtils.getParameter(request, "type","add");
		 if("edit".equals(type)){
			 long id = ServletUtils.getParameterLong(request, "id",null);
			 List<CkuImage> list=ckuMatchVenueSerivce.selectImageById(id);
			 CkuMatchVenue cmv =null;
			 if (list.size()>0) {
				 cmv = ckuMatchVenueSerivce.selectByPrimaryKey(id);
			 }else{
				 cmv =ckuMatchVenueSerivce.selectVenueById(id);
			 }
			 modelMap.addAttribute("matchVenue",cmv);
		 }else{
			 modelMap.addAttribute("matchVenue",null);
		 }
		ModelAndView mv = new ModelAndView("admin/ckuMatchVenue/updateMatchVenue",modelMap);
		return mv;
	}
	/**
	 * 添加赛事场馆
	 */
	@RequestMapping(value="/addVenue")
	public ModelAndView addMatchVenue(HttpServletResponse response,HttpServletRequest request,CkuMatchVenue ckuMatchVenue, ModelMap modelMap)throws IOException{

		//TODO
		int i = ckuMatchVenueSerivce.addMatchVenue(ckuMatchVenue);
		String result = i>0?"success":"error";
		modelMap.addAttribute("toPage","ckuMatchVenue/getList.do");
		modelMap.addAttribute("message",i>0?"添加赛事场馆成功!":"添加赛事场馆失败!");
		ModelAndView mv = new ModelAndView(result,modelMap);
		return mv;
	}
	/**
	 * 修改赛事场馆
	 */
	@RequestMapping(value="/updateVenue")
	public ModelAndView updateMatchVenue(HttpServletResponse response,HttpServletRequest request,CkuMatchVenue ckuMatchVenue, ModelMap modelMap)throws IOException{
		//TODO
		int i =ckuMatchVenueSerivce.updateVenue(ckuMatchVenue);
		String result = i>0?"success":"error";
		modelMap.addAttribute("toPage","ckuMatchVenue/getList.do");
		modelMap.addAttribute("message",i>0?"修改赛事场馆成功!":"修改赛事场馆失败!");
		ModelAndView mv = new ModelAndView(result,modelMap);
		return mv;
	}
	/**
	 * 删除赛事场馆
	 */
	@RequestMapping(value="/deleteVenue")
	@ResponseBody
	public void deleteMatchVenue(HttpServletResponse response,HttpServletRequest request)throws IOException{
		RESTResponse result = null;
		try{
			long id = ServletUtils.getParameterLong(request, "id",null);
			int i = ckuMatchVenueSerivce.deleteByPrimaryKey(id);
			if(i>0){
				result = new RESTResponse(0,"删除赛事场馆成功！");
			}else{
				result = new RESTResponse(1,"删除赛事场馆失败！");
			}
		}catch (Exception e){
			result = new RESTResponse(e);
			logger.error(e);
		}
		ServletUtils.writeResponse(response, result);
	}
	
}
