package com.cab.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cab.dao.TestParamsMapper;
import com.cab.model.TestParams;
import com.cku.core.BaseDAOMapper;
import com.cku.core.BaseService;
import com.cku.core.ExecResultModel;

@Service("testParamsService")
public class TestParamsServiceImpl  extends BaseService<TestParams>{
	@Autowired
	public TestParamsMapper testParamsMapper;
	@Override
	protected BaseDAOMapper<TestParams> getDAO() {
		return this.testParamsMapper;
	}
	public String getParams(Integer interfaceId){
		ExecResultModel<TestParams> resultModel = new ExecResultModel<TestParams>();
		List<TestParams> list = testParamsMapper.getParams(interfaceId);
		resultModel.setItems(list);
		resultModel.setTotal((long) list.size());
		resultModel.setRc(0);
		return resultModel.getToJson();
	}

}
