package com.cab.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cab.dao.CabMymessageMapper;
import com.cab.model.CabMymessage;

@Service("cabMymessageService")
public class CabMymessageServiceImpl {

	@Autowired
	public CabMymessageMapper cabMymessageMapper;

	/**
	 * 得到我的消息列表 --lyy
	 * 
	 * @param userId
	 * @return
	 */
	public List<CabMymessage> getMymessageCount(String userId, String isRead) {
		List<CabMymessage> list = cabMymessageMapper.getMymessageCount(userId, isRead);
		return list;
	}

	public List<CabMymessage> getMymessageByType(String userId, Integer type, String isRead) {
		List<CabMymessage> list = cabMymessageMapper.getMymessageByType(userId, type, isRead);
		return list;
	}

	public CabMymessage getMymessageById(Integer id) {
		CabMymessage result = cabMymessageMapper.selectByPrimaryKey(id);
		return result;
	}

	public int updateIsRead(Integer id) {
		CabMymessage c = new CabMymessage();
		c.setId(id);
		c.setIsread(1);
		return cabMymessageMapper.updateByPrimaryKeySelective(c);

	}

	public int updateAllIsRead(String userId) {
		return cabMymessageMapper.updateAllIsRead(userId);

	}
}
