<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>
<%@ page isELIgnored="false" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=1.0">
    <link rel="stylesheet" href="<%=request.getContextPath() %>/js/reset.css">
    <script src="<%=request.getContextPath() %>/js/zepto.min.js"></script>
    <title>直播页面</title>
</head>
<style>
    body{background-color:#ECEEF3;}
    .header{background:#f9f9f9;height:.96rem;padding:0 .24rem 0 .41rem;padding-top:.18rem;box-sizing:border-box;}
    .logo{float:left;height:.58rem;width:.66rem;background:url(<%=request.getContextPath() %>/img/logo.png) left center no-repeat;background-size:contain;}
    .header a{float:right;height:.56rem;width:1.52rem;border:1px solid #2dcded;font-size:.27rem;line-height:.56rem;text-align:center;font-family:STXihei;color:#2dcded;border-radius:.07rem;-webkit-border-radius:.07rem;}
    .tit{height:.64rem;width:1.14rem;background:url(<%=request.getContextPath() %>/img/cab.png) left top no-repeat;background-size:contain;margin-left:.17rem;float:left;}
    .top-box h3{padding:0 .24rem;font-size:.3rem;line-height:.8rem;font-family:STHeiti;color:#737373;}
    .img-box{position: relative;}
    .img-box{width:100%;height:200rem;}
    .img-box p{height:.62rem;width:100%;background-color:rgba(000,000,000,.55);position:absolute;bottom:0;left:0;}
    .img-box p a{float:right;height:.25rem;width:.25rem;background:url(<%=request.getContextPath() %>/img/icon.png) center center no-repeat;background-size:contain;margin:.21rem .36rem 0 0;}
    .status{padding:0 .37rem 0 .27rem;font-size: 0}
    .status span{font-size:.25rem;line-height:.6rem;margin-right:.09rem;color:#9b9b9b;vertical-align: middle;}
    .status span:nth-child(2){color:#2dcded;}
    .status a{float:right;height:.37rem;width:.39rem;background:url(<%=request.getContextPath() %>/img/share.png) center center no-repeat;background-size:contain;margin-top:.1rem;}
    .content{border-top:8px solid #ededed;padding:0 .32rem;}
    .content .title{font-size:.29rem;color:#4a4a4a;line-height:.75rem;border-bottom:.06rem solid #ebe9e9;}
    .more h3,.item h3{font-size:.30rem;font-family:STHeitiSC-Light;color:#2dcded;line-height:.78rem;}
    .item{position:relative;}
    .item h3 span{background:url(<%=request.getContextPath() %>/img/Path.png) left center no-repeat;margin-right:.05rem;height:.2rem;width:.05rem;display: inline-block;background-size:contain;}
    .item p{font-size:.28rem;line-height:.5rem;color:#4f4f4f;padding-left:.38rem;}
    .last p{padding-left:1.39rem;}
    .item .portrait{position:absolute;left:0;top:.78rem;height:1rem;width:1rem;border-radius:50%;-webkit-border-radius:50%;overflow: hidden;}
    .code{padding:.31rem 0 .35rem;text-align:center;border-bottom:.06rem solid #ebe9e9;}
    .code img{height:1.97rem;width:1.97rem;}
    .code span{display:block;font-size:.23rem;color:#4a4a4a;text-align:center;}
    .more ul{padding-top:.21rem;}
    .more li{padding-bottom:.21rem;}
    .more .sub-logo{float:left;height:1.04rem;width:1.04rem;border-radius:.07rem;-webkit-border-radius:.07rem;overflow:hidden;}
    .more .sub-logo img{height:1.04rem;width:1.04rem}
    .more .cont{margin-left:1.35rem;}
    .more .cont p{font-size:.35rem;line-height:1.04rem;}
    .more .cont a{float:right;height:.35rem;width:.85rem;border-radius:.32rem;-webkit-border-radius:.32rem;font-size:.21rem;color:#FFF;text-align:center;background:rgba(74,73,74,0.50);line-height:.35rem;vertical-align: middle;margin-top:.34rem;}
</style>
<body>
<div class="header">
    <div class="logo"></div>
    <div class="tit"></div>
    <a href="javascript:;">下载APP</a>
</div>
<div class="top-box">
    <h3>[正在播放]${content.contentTitle}<%--宠物美容讲解及注意事项--%></h3>
    <video src="${content.videoUrl}" width="100%" height="200px" autoplay="autoplay" poster="${content.thumbUrl}"></video>
    <%--<div id="jquery_jplayer" class="img-box"></div>--%>
<%--    <div class="status">
        <span>直播中</span><span>12:32</span><a href="javascript:;"></a>
    </div>--%>

</div>
<div class="content">
    <div class="title">详情</div>
    ${content.contentDetail}
<%--    <div class="item">
        <h3><span></span>栏目介绍</h3>
        <p>宠爱王国专业美容专栏。不定期为您更新美容教程等精彩内容。</p>
    </div>
    <div class="item">
        <h3><span></span>课程介绍</h3>
        <p>宠物美容讲解及注意事项。让您深入的了解美容行业的乐趣。</p>
    </div>
    <div class="item last">
        <h3><span></span>讲师介绍</h3>
        <div class="portrait"><img src="static/images/Group 14.png" alt=""></div>
        <p>维克多，中国小王子犬舍主理人，有多年宠物美容经验。</p>
        <div class="code">
            <img src="static/images/Group 14.png" alt="">
            <span>长按关注“宠爱club”</span>
        </div>
    </div>--%>
    <div class="more">
        <h3>更多精彩内容尽在宠爱王国App</h3>
        <ul>
            <c:forEach var="item" items="${nextList}">
                <li class="clearfix" onclick="nextContent(${item.contentId})">
                    <div class="sub-logo">
                        <img src="${item.thumbMinUrl}" alt="">
                    </div>
                    <div class="cont">
                        <p>${item.contentTitle}<a href="javascript:;">${item.videoTime}</a></p>
                    </div>
                </li>
            </c:forEach>
<%--            <li class="clearfix">
                <div class="sub-logo">
                    <img src="static/images/Group 14.png" alt="">
                </div>
                <div class="cont">
                    <p>适合一些懒狗的训练<a href="javascript:;">00：59</a></p>
                </div>
            </li>
            <li class="clearfix">
                <div class="sub-logo">
                    <img src="static/images/Group 14.png" alt="">
                </div>
                <div class="cont">
                    <p>适合一些懒狗的训练<a href="javascript:;">00：59</a></p>
                </div>
            </li>--%>
        </ul>
    </div>
</div>
</body>
<script>
    (function (doc, win) {
        var docEl = doc.documentElement,
                resizeEvt = 'orientationchange' in window ? 'orientationchange' : 'resize',
                recalc = function () {
                    var clientWidth = docEl.clientWidth;
                    if (!clientWidth) return;
                    docEl.style.fontSize = 100 * (clientWidth / 720) + 'px';
                };

        if (!doc.addEventListener) return;
        win.addEventListener(resizeEvt, recalc, false);
        doc.addEventListener('DOMContentLoaded', recalc, false);
    })(document, window);
    function nextContent(id){
        window.location.href="<%=request.getContextPath()%>/player.do?id="+id;
    }

    $(function(){
        var targetUrl = encodeURIComponent(window.location.href);
        getjstoken(targetUrl);
    })
    function getjstoken(targetUrl){
        $.ajax({
            url: '<%=request.getContextPath() %>/wechat/getjssdktoken.do',
            type: 'post',
            dataType : 'json',
            data:{url:targetUrl},
            success: function(data){
                token = data.token;
                wx.config({
                    debug: false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
                    appId: token.appid, // 必填，公众号的唯一标识
                    timestamp: token.timestamp, // 必填，生成签名的时间戳
                    nonceStr: token.nocestr, // 必填，生成签名的随机串
                    signature: token.signature,// 必填，签名，见附录1
                    jsApiList: ['onMenuShareTimeline',
                        'onMenuShareAppMessage'] // 必填，需要使用的JS接口列表，所有JS接口列表见附录2
                });

                wx.ready(function(){
                    // config信息验证后会执行ready方法，所有接口调用都必须在config接口获得结果之后，config是一个客户端的异步操作，
                    // 所以如果需要在页面加载时就调用相关接口，则须把相关接口放在ready函数中调用来确保正确执行。对于用户触发时才调用的接口，则可以直接调用，不需要放在ready函数中。
                    //alert(window.location.href);
//                    var media = document.getElementById("audi");
//                    if (typeof WeixinJSBridge == "object" && typeof WeixinJSBridge.invoke == "function") {
//                        WeixinJSBridge.invoke('getNetworkType', {}, function (res) {
//                            // 在这里拿到 e.err_msg, 这里面就包含了所有的网络类型
//                            // alert(res.err_msg);
//                            media.play();
//                        });
//                    }

                    // 1 判断当前版本是否支持指定 JS 接口，支持批量判断
                    wx.checkJsApi({
                        jsApiList: [
                            'onMenuShareTimeline',
                            'onMenuShareAppMessage'
                        ],
                        success: function (res) {
                            //alert("zhichi");
                            //console.log(res);
                        },
                        fail:function(){
                            //alert("buzhichi");
                        },
                        complete: function(){
                            //alert("checkJsApi complete");
                        }
                    });

                    //朋友圈
                    wx.onMenuShareTimeline({
                        title: '${content.contentTitle}', // 分享标题
                        link: '<%=request.getContextPath()%>/player.do?id=${content.contentId}', // 分享链接
                        imgUrl: "${content.thumbUrl}", // 分享图标
                        success: function () {
                            // 用户确认分享后执行的回调函数
                            //alert("分享给朋友圈 success");
                        },
                        cancel: function () {
                            // 用户取消分享后执行的回调函数
                            //alert("分享给朋友圈 cancel");
                        }
                    });
                    //朋友
                    wx.onMenuShareAppMessage({
                        title: '${content.contentTitle}', // 分享标题
                        desc: '${content.contentTitle}', // 分享描述
                        link: '<%=request.getContextPath()%>/player.do?id=${content.contentId}', // 分享链接
                        imgUrl: "${content.thumbUrl}", // 分享图标
                        type: 'link', // 分享类型,music、video或link，不填默认为link
                        dataUrl: '', // 如果type是music或video，则要提供数据链接，默认为空
                        success: function () {
                            // 用户确认分享后执行的回调函数
                            //alert("分享给朋友 success");
                        },
                        fail: function(){
                            //alert("分享给朋友 fail");
                        },
                        cancel: function () {
                            // 用户取消分享后执行的回调函数
                            //alert("分享给朋友 cancel");
                        }
                    });


                });
                wx.error(function(res){
                    // config信息验证失败会执行error函数，如签名过期导致验证失败，具体错误信息可以打开config的debug模式查看，也可以在返回的res参数中查看，对于SPA可以在这里更新签名。
                    //alert("error");
                });

            },
            error:function(){
                alert(error);
            }
        });
    }
</script>
</html>
