package com.cab.controller;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cab.model.TestInterface;
import com.cab.service.TestInterfaceServiceImpl;
import com.cab.service.TestParamsServiceImpl;

@Controller
@RequestMapping(value="testInterface")
public class TestInterfaceController {
	private static final Logger logger = Logger.getLogger(TestInterfaceController.class);
	@Autowired
	public TestInterfaceServiceImpl testInterfaceSerivce;
	@Autowired
	public TestParamsServiceImpl testParamsSerivce;
	
	//得到所有接口
	@RequestMapping(value="/getAll")
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void getTestInterfaceAll(HttpServletResponse response,HttpServletRequest request) {
		try {
			System.out.println("test--------------");
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String result = testInterfaceSerivce.getTestInterfaceAll();
		    response.getWriter().write(result);
		} catch (Exception e) {
			// TODO: handle exception
			logger.error(e);
		}
	}
	
	//得到所有接口
	@RequestMapping(value="/getByPId")
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void getTestInterfaceByPId(HttpServletResponse response,HttpServletRequest request) {
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String id = request.getParameter("id");
			String result = testInterfaceSerivce.getTestInterfaceByPId(Integer.valueOf(id));
		    response.getWriter().write(result);
		} catch (Exception e) {
			// TODO: handle exception
			logger.error(e);
		}
	}
	
	//得到参数
	@RequestMapping(value="/getParams")
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void getParams(@RequestParam(value = "interfaceId", required = false)Integer interfaceId,
			HttpServletResponse response,HttpServletRequest request) {
		try {
			System.out.println("test--------------");
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String result = testParamsSerivce.getParams(interfaceId);
		    response.getWriter().write(result);
		} catch (Exception e) {
			// TODO: handle exception
			logger.error(e);
		}
	}
	
	//添加接口方法
	@RequestMapping(value="/add",method=RequestMethod.POST, headers = {"content-type=application/json","content-type=application/xml"})
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void add(HttpServletResponse response,HttpServletRequest request,@RequestBody TestInterface testInterface) {
		try {
			System.out.println("test--------------");
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String result = testInterfaceSerivce.add(testInterface);
		    response.getWriter().write(result);
		} catch (Exception e) {
			// TODO: handle exception
			logger.error(e);
		}
	}
}
