package com.cab.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.alibaba.druid.util.StringUtils;
import com.cab.model.CabKeyword;
import com.cab.model.Content;
import com.cab.model.ContentFollow;
import com.cab.model.ContentType;
import com.cab.service.ContentCommentServiceImpl;
import com.cab.service.ContentServiceImpl;
import com.cab.service.UserService;
import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.util.PageBean;
import com.cku.util.ServletUtils;

@Controller
@RequestMapping(value="content")
public class ContentController {
	// private static final Logger logger = Logger.getLogger(ProvinceController.class);
	
	@Autowired
	public ContentServiceImpl contentService;

	@Autowired
	public ContentCommentServiceImpl contentCommentService;
	/**
	 * 得到一级分类下的数据
	 * @param response
	 * @param request
	 * @throws IOException
	 */
	@RequestMapping(value = "/suggest2")
	public void api_suggest(HttpServletResponse response, HttpServletRequest request) throws IOException
	{
		RESTResponse result = null;
		try
		{
			//String type = ServletUtils.getParameter(request, "type", "pictext");
			// if (type.equals("pictext"))
			{
				List<ContentType> l = contentService.GetPictureSuggest();
				PageBeanResult<ContentType> pbr = new PageBeanResult<ContentType>(l);
				result = new RESTResponse("items", pbr);
			}
			
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}
		
		ServletUtils.writeResponse(response, result);
	}
//	/**
//	 * 得到三级分类的分页集合
//	 * @param response
//	 * @param request
//	 * @throws IOException
//	 */
//	@RequestMapping(value = "/content3")
//	public void api_list(HttpServletResponse response, HttpServletRequest request) throws IOException
//	{
//		RESTResponse result = null;
//		try
//		{
//			String contentTypeId = ServletUtils.getParameter(request, "content_type_id");
//			PageBean pb = ServletUtils.getParameterBean(request);
//			
//			PageBeanResult<Content> pbr = contentService.GetByContentTypeId(contentTypeId, pb);
//			result = new RESTResponse("items", pbr);
//		}
//		catch (Exception e)
//		{
//			result = new RESTResponse(e);
//		}
//		
//		ServletUtils.writeResponse(response, result);
//	}
	/**
	 * 得到消息详细
	 * @param response
	 * @param request
	 * @throws IOException
	 */
	@RequestMapping(value = "/detail")
	public void api_detail(HttpServletResponse response, HttpServletRequest request) throws IOException
	{
		RESTResponse result = null;
		try
		{
			Long contentId = ServletUtils.getParameterLong(request, "contentId");
			PageBean pb = ServletUtils.getParameterBean(request);
			String userId = UserService.verifyUserId(request);
			//TODO 添加回复分页
			Content item = contentService.GetContentDetails(contentId, userId,pb);
			result = new RESTResponse("items", item);
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 评论回复的list集合
	 * @param response
	 * @param request
	 * @throws IOException
	 */
	@RequestMapping(value = "/commentFollowList")
	public void api_comment_follow_list(HttpServletResponse response, HttpServletRequest request) throws IOException
	{
		RESTResponse result = null;
		try
		{
			Long commentId = ServletUtils.getParameterLong(request, "commentId");
			PageBean pb = ServletUtils.getParameterBean(request);
			
			PageBeanResult<ContentFollow> list = contentCommentService.getContentFollowList(commentId, pb);
			result = new RESTResponse("items", list);
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}
		
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 评论消息
	 * @param response
	 * @param request
	 * @throws IOException
	 */
	@RequestMapping(value = "/comment")
	public void api_comment(HttpServletResponse response, HttpServletRequest request) throws IOException
	{
		RESTResponse result = new RESTResponse();
		try
		{
			Long contentId = ServletUtils.getParameterLong(request, "contentId");
			String content = ServletUtils.getParameter(request, "content");
			String userId = UserService.verifyUserId(request);
			//JSONObject jo = StreamUtils.readJSONFromInputStream(request.getContentLength(), request.getInputStream());
			//String content = jo.getString("content");
			
			contentCommentService.addComment(contentId, userId, content);
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}
		
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 评论回复
	 * @param response
	 * @param request
	 * @throws IOException
	 */
	@RequestMapping(value = "/commentFollow")
	public void api_comment_follow(HttpServletResponse response, HttpServletRequest request) throws IOException
	{
		RESTResponse result = new RESTResponse();
		try
		{
			Long commentId = ServletUtils.getParameterLong(request, "commentId");
			String userId = UserService.verifyUserId(request);
			String toId = ServletUtils.getParameter(request, "toId", null);
			String content = ServletUtils.getParameter(request, "content");
//			JSONObject jo = StreamUtils.readJSONFromInputStream(request.getContentLength(), request.getInputStream());
//			String content = jo.getString("content");
			
			contentCommentService.addCommentFollow(commentId, userId, toId, content);
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}
		
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 收藏 点赞 添加和删除
	 * @param response
	 * @param request
	 * @throws IOException
	 */
	@RequestMapping(value = "/action")
	public void api_action(HttpServletResponse response, HttpServletRequest request) throws IOException
	{
		RESTResponse result = new RESTResponse();
		try
		{
			Long contentId = ServletUtils.getParameterLong(request, "contentId",null);
			String userId = UserService.verifyUserId(request);
			String action = ServletUtils.getParameter(request, "action");
			String contentIdArrStr = ServletUtils.getParameter(request, "contentIdArrStr",null);
			
			if (action.equals("add_up"))
			{
				contentService.addAction(contentId, userId, ContentServiceImpl.CU_TYPE_UP);
			}
			else if (action.equals("add_fav"))
			{
				contentService.addAction(contentId, userId, ContentServiceImpl.CU_TYPE_FAVORITE);
			}
			else if (action.equals("del_fav"))
			{
				contentService.removeAction(contentId, userId, ContentServiceImpl.CU_TYPE_FAVORITE);				
			}
			else if (action.equals("del_fav_arr"))
			{
				String[] contentIdArr = contentIdArrStr.split(",");
				for(String contentIdi : contentIdArr){
					contentService.removeAction(Long.parseLong(contentIdi), userId, ContentServiceImpl.CU_TYPE_FAVORITE);
				}
								
			}
			else if (action.equals("del_up"))
			{
				contentService.removeAction(contentId, userId, ContentServiceImpl.CU_TYPE_UP);				
			}
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}
		
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 查询我的收藏方法
	 * @param request
	 * @param response
	 * @throws IOException
     */
	@RequestMapping(value = "/searchFavorite")
	public void searchFavorite(HttpServletRequest request,HttpServletResponse response) throws IOException {
		RESTResponse result = null;
		try {
			String userId = UserService.verifyUserId(request);
			String title = ServletUtils.getParameter(request,"title",null);
			PageBean pb = ServletUtils.getParameterBean(request);
			PageBeanResult<Content> pbr = contentService.searchFavorite(userId,title,pb);
			result = new RESTResponse("items", pbr);
		} catch (Exception e) {
			result = new RESTResponse(e);
		}

		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 关键字搜索
	 * @param response
	 * @param request
	 * @throws IOException
	 */
	@RequestMapping(value = "/searchContentByKeyWord")
	public void searchContentByKeyWord(HttpServletResponse response, HttpServletRequest request) throws IOException{
		RESTResponse result = null;
		try{
			String userId = UserService.verifyUserId(request);
			String contentTypeId = ServletUtils.getParameter(request, "contentTypeId",null);
			String contentTypeParentId = ServletUtils.getParameter(request, "contentTypeParentId",null);
			String title = ServletUtils.getParameter(request, "title",null);
			PageBean pb = ServletUtils.getParameterBean(request);
			List<CabKeyword> keywordList = contentService.getKeywordList(pb.get_start(),title);
			PageBeanResult<Content> pbr = contentService.getByContentType(userId,contentTypeParentId,contentTypeId,title, pb);
			HashMap<String,Object> map = new HashMap<String, Object>();
			HashMap<String,Object> mappb = new HashMap<String, Object>();
			mappb.put("list",pbr.getList());
			mappb.put("total",pbr.getTotalCount());
			map.put("pb",mappb);
			map.put("keyword",keywordList);
			result = new RESTResponse("items", map);
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}
		
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 根据三级type分类获取分类下的信息
	 * @param response
	 * @param request
	 * @throws IOException
	 */
	@RequestMapping(value = "/content3")
	public void getContentByType(HttpServletResponse response, HttpServletRequest request) throws IOException{
		RESTResponse result = null;
		try{
			String userId = UserService.verifyUserId(request);
			String contentTypeId = ServletUtils.getParameter(request, "contentTypeId",null);
			String contentTypeParentId = ServletUtils.getParameter(request, "contentTypeParentId",null);
			String title = ServletUtils.getParameter(request, "title",null);
			if(StringUtils.isEmpty(contentTypeId) && StringUtils.isEmpty(contentTypeParentId)){
				throw new Exception("参数contentTypeId与contentTypeParentId不可以同时为空！");
			}

			PageBean pb = ServletUtils.getParameterBean(request);
			PageBeanResult<Content> pbr = contentService.getByContentType(userId,contentTypeParentId,contentTypeId,title, pb);
			result = new RESTResponse("items", pbr);
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}
		
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 得到第一页信息
	 * @param response
	 * @param request
	 * @throws IOException
	 */
	@RequestMapping(value = "/suggest")
	public void getIsFirst(HttpServletResponse response, HttpServletRequest request) throws IOException{
		RESTResponse result = null;
		try{
			int type = ServletUtils.getParameterInt(request, "type", 0);
			List<ContentType> list = contentService.getIsFirst(type);
			result = new RESTResponse("items", list);
		}catch (Exception e){
			result = new RESTResponse(e);
		}
		
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 得到专题三级分类
	 * @param response
	 * @param request
	 * @throws IOException
	 */
	@RequestMapping(value = "/getSubjectType")
	public void getSubjectType(HttpServletResponse response, HttpServletRequest request) throws IOException{
		RESTResponse result = null;
		try{
			int type = ServletUtils.getParameterInt(request, "type", 0);
			List<ContentType> list = contentService.getSubjectType(type);
			result = new RESTResponse("items", list);
		}catch (Exception e){
			result = new RESTResponse(e);
		}

		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 得到所有分类 lyy
	 * @param response
	 * @param request
	 * @throws IOException 
	 */
	@RequestMapping(value = "/getAllType")
	public void getAllType(HttpServletResponse response, HttpServletRequest request) throws IOException{
		RESTResponse result = null;
		try{
			List<ContentType> items = contentService.getAllType();
			result = new RESTResponse("items", items);
		}catch (Exception e){
			result = new RESTResponse(e);
		}
		
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 得到所有推荐消息 lyy
	 * @param response
	 * @param request
	 * @throws IOException 
	 */
	@RequestMapping(value = "/getAllIsTop")
	public void getAllIsTop(HttpServletResponse response, HttpServletRequest request) throws IOException{
		RESTResponse result = null;
		try{
			PageBean pb=ServletUtils.getParameterBean(request);
			PageBeanResult<Content> items = contentService.getAllIsTop(pb);
			result = new RESTResponse("items", items);
		}catch (Exception e){
			result = new RESTResponse(e);
		}
		ServletUtils.writeResponse(response, result);
	}
}
