package com.sys.model;

import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;

public class AreaTreeResponse implements Serializable {

	private static final long serialVersionUID = 205571678827613192L;

	@JsonIgnore
	private String value;

	private String label;

	@JsonIgnore
	private String parentValue;

	@JsonIgnore()
	private Integer type;

	@JsonInclude(JsonInclude.Include.NON_NULL)
	List<AreaTreeResponse> children;
	
	public AreaTreeResponse(String value, String label, String parentValue, Integer type,
			List<AreaTreeResponse> children) {
		super();
		this.value = value;
		this.label = label;
		this.parentValue = parentValue;
		this.type = type;
		this.children = children;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public String getParentValue() {
		return parentValue;
	}

	public void setParentValue(String parentValue) {
		this.parentValue = parentValue;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public List<AreaTreeResponse> getChildren() {
		return children;
	}

	public void setChildren(List<AreaTreeResponse> children) {
		this.children = children;
	}
	
}
