package com.cab.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cab.dao.TestInterfaceMapper;
import com.cab.dao.TestParamsMapper;
import com.cab.model.TestInterface;
import com.cab.model.TestParams;
import com.cku.core.BaseDAOMapper;
import com.cku.core.BaseService;
import com.cku.core.ExecResultModel;

@Service("testInterfaceSerivce")
public class TestInterfaceServiceImpl  extends BaseService<TestInterface>{
	@Autowired
	public TestInterfaceMapper testInterfaceMapper;
	
	@Autowired
	public TestParamsMapper testParamsMapper;
	@Override
	protected BaseDAOMapper<TestInterface> getDAO() {
		return this.testInterfaceMapper;
	}
	public String getTestInterfaceAll(){
		ExecResultModel<TestInterface> resultModel = new ExecResultModel<TestInterface>();
		List<TestInterface> list = testInterfaceMapper.getAll();
		resultModel.setItems(list);
		resultModel.setTotal((long) list.size());
		resultModel.setRc(0);
		return resultModel.getToJson();
	}
	
	public String getTestInterfaceByPId(int id){
		ExecResultModel<TestInterface> resultModel = new ExecResultModel<TestInterface>();
		List<TestInterface> list = testInterfaceMapper.getByPId(id);
		resultModel.setItems(list);
		resultModel.setTotal((long) list.size());
		resultModel.setRc(0);
		return resultModel.getToJson();
	}
	
	public String add(TestInterface testInterface){
		ExecResultModel<String> resultModel = new ExecResultModel<String>();
		testInterface.setCreateTime(new Date());
		if(testInterface.getId() != null){
			testInterfaceMapper.updateByPrimaryKey(testInterface);
		}else{
			testInterfaceMapper.insertSelective(testInterface);
		}
		
		List<TestParams> list = testInterface.getParamList();
		if(list!=null && list.size()>0){
			for(int i=0;i<list.size();i++){
				TestParams testParams = list.get(i);
				testParams.setCreateTime(new Date());
				testParams.setInterfaceId(testInterface.getId());
				testParamsMapper.insertSelective(list.get(i));
			}
		}
		resultModel.setItems(new ArrayList<String>());
		resultModel.setTotal((long) 0);
		resultModel.setRc(0);
		return resultModel.getToJson();
	}

}
