package com.cab.service;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cab.dao.zxbUserMapper;
import com.cab.model.zxbUserModel;

/**
 * 
 * <p>Title:LoginServiceImpl </p>
 * <p>Description: 用户登录控制层</p>
 * <p>Company: </p> 
 * @author zhuoHeng
 * @date 2016年5月11日 下午3:57:23
 */
@Service("loginService")
public class LoginServiceImpl {
	
	public static final String USER_NOT_FOUND ="userNotFound";
	public static final String INVALID_PASSWORD ="invalidPassword";
	public static final String LOGIN_SUCCESS ="success";
	
	@Autowired
	public zxbUserMapper zxbUserMapper;
	
	/**
	 * 
	 * @Description：验证登录账号密码
	 * @author: zhuoHeng
	 * @version: 2016年5月11日 下午4:02:15
	 */
	public String getLoginUser(String userName,String passWord,HttpServletRequest request){
		
		String message="";
		zxbUserModel zxbUserModel = zxbUserMapper.selectByUserName(userName);
		
		if(zxbUserModel==null){
			message = USER_NOT_FOUND;
		}else{
			if(passWord.equals(zxbUserModel.getPassWord())){
				HttpSession session = request.getSession();
				session.setAttribute("userId", zxbUserModel.getId());
				session.setAttribute("userName", zxbUserModel.getUserName());
				message = LOGIN_SUCCESS;
			}else{
				message = INVALID_PASSWORD;
			}
		}
		
		return message;
		
	}
	/**
	 * 
	 * @Description：向session中存入用户数据
	 * @author: zhuoHeng
	 * @version: 2016年5月11日 下午7:01:47
	 */
	public zxbUserModel getUserMessage(String userName){
		
		zxbUserModel zxbUserModel = zxbUserMapper.selectByUserName(userName);
		
		return zxbUserModel;
	}
	

}
