<%@ page language="java" contentType="text/html;charset=UTF-8" %> 
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %> 
<%@ page isELIgnored="false" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
        "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
    <title>内容管理列表</title>
    <meta http-equiv="Content-Type" content="text/html;charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
	<link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap.min.css">
	<link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap-theme.min.css">
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/jquery/Jquery.Query.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/bootstrap/js/bootstrap.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/jquery.twbsPagination/jquery.twbsPagination.js"></script>
    <script type="text/javascript">
    var typeList1 = [{ 'contentTypeId': '', 'name': '全部', 'level': 1 }, 
             		<c:forEach var="type" items="${contentTypeList1}">
             			{ 'contentTypeId': '${type.id}', 'name': '${type.name}', 'level': ${type.level} }, 
             		</c:forEach>
             		];
                 	var typeList2 = [{ 'contentTypeId': '', 'name': '全部', 'level': 2 }, 
             		<c:forEach var="type" items="${contentTypeList2}">
             			{ 'contentTypeId': '${type.id}', 'name': '${type.name}', 'level': ${type.level}, 'parentTypeId': '${type.parentTypeId}' }, 
             		</c:forEach>
             		];
                 	var typeList3 = [{ 'contentTypeId': '', 'name': '全部', 'level': 3 }, 
             		<c:forEach var="type" items="${contentTypeList3}">
             			{ 'contentTypeId': '${type.id}', 'name': '${type.name}', 'level': ${type.level}, 'parentTypeId': '${type.parentTypeId}' }, 
             		</c:forEach>
             		];
                 	var sel1, sel2, sel3;
                 	function build_option_htm(type, selected)
                 	{
                 		var htm = "<option value='" + type.contentTypeId + "'";
                 		if (selected)
                 		{
                 			htm += " selected='selected'";
                 		}
                 		htm += ">" + type.name + "</option>";
                 		return htm;    		
                 	}
                 	function build_select()
                 	{
                 		sel1 = $("#sel1");
                 		sel2 = $("#sel2");
                 		sel3 = $("#sel3");
                 		
                 		var first = true;
                 		for (var i = 0; i < typeList1.length; ++i)
                 		{
                 			var type = typeList1[i];
             				var htm = build_option_htm(type, first);
             				sel1.append(htm);
             				first = false;    			
                 		}
                 		
                 		change_select1(typeList1[0].contentTypeId);    		
                 		
                 		sel1.change(function() {
                 			change_select1(sel1.val());
                 		});

                 		sel2.change(function() {
                 			change_select2(sel2.val());
                 		});
                 		
                 	}
                 	function change_select1(val)
                 	{
                 		sel2.empty();    		
                 		var first = true;
                 		
                 		for (var i = 0; i < typeList2.length; ++i)
                 		{
                 			var type = typeList2[i];
                 			if (type.parentTypeId == parseInt(val))
                 			{
                 				var htm = build_option_htm(type, first);
                 				sel2.append(htm);
                 				if (first)
                 				{
                 					change_select2(type.contentTypeId);
                 					first = false;
                 				}
                 			}
                 		}
                 	}
                 	function change_select2(val)
                 	{
                 		sel3.empty();    		
                 		var first = true;
                 		
                 		for (var i = 0; i < typeList3.length; ++i)
                 		{
                 			var type = typeList3[i];
                 			if (type.parentTypeId == parseInt(val) || type.contentTypeId == -1)
                 			{
                 				var htm = build_option_htm(type, first);
                 				sel3.append(htm);
                 				first = false;
                 			}
                 		}
                 	}
    </script>
</head>
<body>
<div class="container-fluid">
	<form class="form-inline" action="<%=request.getContextPath() %>/publish/list.do">
	<div class="row">
		<div class="col-md-4">
			 <div class="form-group">
			    <label>标题：</label>  
			    <input type="title" class="form-control" value="${param.title}" name="title" placeholder="标题">
			  </div>
		</div>
		<div class="col-md-4">
			 <div class="form-group">
			    <label>分类：</label>  
					<select id="sel1" name="contentType1" class="form-control">
					</select>	
					<select id="sel2" name="contentType2" class="form-control">
					</select>	
					<select id="sel3" name="contentType3" class="form-control">
					</select>
			  </div>
		</div>

		<div class="col-md-2">
			 <div class="form-group">
			    <label>今日推荐:</label>
			    <input type="hidden" name="isTop" id="isTopHidden" value="${param.isTop==null?'all':param.isTop}"/>
			    <select  id="isTopSel" onchange="selectVal('isTop')" class="form-control">
					<option id="isTop1" value="yes" selected="">是</option>  
					<option id="isTop2" value="no" selected="">否</option>
					<option id="isTop0" value="all" selected="">全部</option>
				</select>	
			  </div>
		</div>
		<div class="col-md-2">
			 <div class="form-group">
			    <label>置顶:</label>
			    <input type="hidden" name="isFirst" id="isFirstHidden" value="${param.isFirst==null?'all':param.isFirst}"/>
			    <select id="isFirstSel" onchange="selectVal('isFirst')" class="form-control">
		    		<option id="isFirst1" value="yes" selected="">是</option>  
					<option id="isFirst2" value="no" selected="">否</option>
					<option id="isFirst0" value="all" selected="">全部</option>

				</select>	
			  </div>
		</div>
	</div>
		<div class="alert alert-info" style="text-align: center;margin-top: 5px;" role="alert">
			<button type="button" onclick="tijiao()" class="btn btn-default">提交</button>
			<a type="button" href="<%=request.getContextPath() %>/publish/list.do" class="btn btn-default">重置/刷新</a>
			<a class="btn btn-success" style="margin-right: 10px;" href="<%=request.getContextPath() %>/publish/view.do">添加</a>
		</div>
		<div class="row">
			<table class="table table-striped">
		      <thead>
		        <tr>
		          <th>主标题</th>
		          <th>副标题</th>
		          <th>分类</th>
		          <th>缩略图</th>
		          <th>banner</th>
		          <th>视频</th>
		          <th>创建时间</th>
		          <th>操作</th>
		        </tr>
		      </thead>
		      <tbody>
		<c:forEach var="item" items="${contentList.list}">
		        <tr>
		          <td style="width:200px;">${item.title}</td>
		          <td style="width:200px;">${item.subTitle}</td>
		          <td >
		          ${item.showContentTypeName}
		          </td>
					<c:choose>
					       <c:when test="${item.thumb!=null && item.thumb!=''}">
					              <td>有</td>
					       </c:when>
					       <c:otherwise>
					              <td>无</td>
					       </c:otherwise>
					</c:choose>
					<c:choose>
					       <c:when test="${item.headerBanner!=null && item.headerBanner!=''}">
					              <td>有</td>
					       </c:when>
					       <c:otherwise>
					              <td>无</td>
					       </c:otherwise>
					</c:choose>
					<c:choose>
					       <c:when test="${item.videoUrl!=null && item.videoUrl!=''}">
					              <td>有</td>
					       </c:when>
					       <c:otherwise>
					              <td>无</td>
					       </c:otherwise>
					</c:choose>
		          <td><fmt:formatDate value="${item.createTime}" pattern="yyyy-MM-dd HH:mm:ss" /> </td>
		          <td>
		          	<c:if test="${item.isTop==0}">
		          		<button type="button" onclick="changeStatus(${item.id},'isTop',${item.isTop})" class="btn btn-success">未今日推荐</button>
		          	</c:if>
		          	<c:if test="${item.isTop==1}">
		          		<button type="button" onclick="changeStatus(${item.id},'isTop',${item.isTop})" class="btn btn-success">已今日推荐</button>
		          	</c:if>
		          	<c:if test="${item.isFirst==0}">
		          		<button type="button" onclick="changeStatus(${item.id},'isFirst',${item.isFirst})" class="btn btn-info">未置顶</button>
		          	</c:if>
		          	<c:if test="${item.isFirst==1}">
		          		<button type="button" onclick="changeStatus(${item.id},'isFirst',${item.isFirst})" class="btn btn-info">已置顶</button>
		          	</c:if>
					  <a class="btn btn-primary"  href="<%=request.getContextPath() %>/publish/toedit.do?id=${item.id}">修改</a>
					  <%-- <button type="button" onclick="toedit(${item.id})" class="btn btn-primary">修改</button> --%>
					  <button type="button" onclick="del(${item.id})" class="btn btn-danger">删除</button>
		          </td>
		        </tr>
		</c:forEach>
		      </tbody>
		    </table>
		</div>
			<input type="hidden" id="pageval" name="page" class="form-control" value="${param.page==null?1:param.page}">
			<input type="hidden" name="limit" class="form-control" value="10">
		<div class="row" id="pageShow" style="text-align: center;">
		
			  <nav id="pagination_box"><ul class="pagination" id="pagercontent"></ul></nav>
		</div>
</form>
</div>
<script>
build_select();
$(function(){
	initVal();
})
function selectVal(type){
	var val = $("#"+type+"Sel").val();
	$("#"+type+"Hidden").val(val);
}
function initVal(){
	var isFirst = $("#isFirstHidden").val();
	if(isFirst=='all'){
		$("#isFirst0").attr("selected","selected");
	}else if(isFirst=='yes'){
		$("#isFirst1").attr("selected","selected");
	}else{
		$("#isFirst2").attr("selected","selected");
	}
	var isTop = $("#isTopHidden").val();
	if(isTop=='all'){
		$("#isTop0").attr("selected","selected");
	}else if(isTop=='yes'){
		$("#isTop1").attr("selected","selected");
	}else{
		$("#isTop2").attr("selected","selected");
	}
/*  	var contentType1 = $("#contentType1").val();
	var contentType2 = $("#contentType2").val();
	var contentType3 = $("#contentType3").val();
	var html1="";
	var html2="";
	var html3="";
	if(contentType1=='all'){
		$("#sel2").html("<option value=\"all\" selected=\"selected\">全部</option>");
		$("#sel3").html("<option value=\"all\" selected=\"selected\">全部</option>");
	}else{
		
	}
	$.each(typeList1, function(index,item) {
		if(item.contentTypeId==contentType1){
			html1+="<option value=\""+item.contentTypeId+"\" selected=\"selected\">"+item.name+"</option>";
		}else{
			html1+="<option value=\""+item.contentTypeId+"\">"+item.name+"</option>";
		}
	});
	console.log(html1);
	$("#sel1").html(html1);  */
}
function tijiao(){
	$('#pageval').val(1);
	$("form").submit();
}
$('#pagercontent').twbsPagination({
	  startPage: ${param.page==null?1:param.page},
	  initiateStartPageClick: false,
	  totalPages: ${contentList.totalCount}==0?1:Math.ceil(${contentList.totalCount}/10),
	  onPageClick: function (event, page) {
	    $('#pageval').val(page);
	    $("form").submit();
	  }
	});
function del(id){
    	$.ajax( { 
    		type:"POST", 
    		url:"<%=request.getContextPath() %>/publish/del.do", 
    		dataType: 'json',
    		data: {id:id}, 
    		async:true,
    		success: function (data) {
    			location.reload();
    		}, 
    		error: function (data) {
    			alert('提交失败');
    		}    		
    	});
}
function changeStatus(id,type,isVal){
	    	$.ajax( { 
    		type:"POST", 
    		url:"<%=request.getContextPath() %>/publish/changeStatus.do", 
    		dataType: 'json',
    		data: {id:id,type:type,isVal:isVal},  
    		async:true,
    		success: function (data) {
    			location.reload();
    		}, 
    		error: function (data) {
    			alert('提交失败');
    		}    		
    	});
}
</script>
</body>
</html>