package com.sys.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.cku.core.BaseDAOMapper;
import com.cku.core.BaseService;
import com.cku.core.PageBeanResult;
import com.sys.dao.ProvinceMapper;
import com.sys.model.Province;

@Service("provinceService")
public class ProvinceServiceImpl extends BaseService<Province>{
	@Autowired
	public ProvinceMapper provinceMapper;
	
	@Override
	protected BaseDAOMapper<Province> getDAO() {
		return this.provinceMapper;
	}
	
	public PageBeanResult<Province> getList(){
		
		List<Province> list = provinceMapper.selectAll();
		
		PageBeanResult<Province> prResult = new PageBeanResult<Province>();
		prResult.list = list;
		prResult.totalCount = (long)list.size();
		
		return prResult;
	}

}
