package com.cku.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.dao.BreedCertifiedMapper;
import com.cku.dao.CkuPayTypeMapper;
import com.cku.dao.DogNewBornMapper;
import com.cku.model.CkuPayType;
import com.cku.model.Dog;
import com.cku.model.DogNewBorn;
import com.cku.util.Debugger;

@Service("breedCertifiedService")
public class BreedCertifiedServiceImpl {

    @Autowired
    public BreedCertifiedMapper breedCertifiedMapper;
    @Autowired
    public DogNewBornMapper dogNewBornMapper;
    @Autowired
    public PublicService publicService;
    @Autowired
    public CkuPayTypeMapper ckuPayTypeMapper;
    
    /**
     * 
     * @Description：根据会员号、血统证书号、性别查询犬只信息
     * @author: zhuoHeng
     * @version: 2016年7月28日 上午10:49:38
     * @throws ZAException 
     */
    public Dog getDogInfo(String memberNum,String pedigreeCertified,String dogGender) throws ZAException{
        
        Dog dogInfo = breedCertifiedMapper.getDogInfo(memberNum,pedigreeCertified,dogGender);
        Debugger.doAssert(dogInfo!=null, ZAErrorCode.ZA_DOG_NOT_FOUND, "请输入正确的血统证书号！");
        
        return dogInfo;
    }

    /**
     * 
     * @Description：会员提交犬只配种证明申请
     * @author: zhuoHeng
     * @version: 2016年7月28日 下午1:50:38
     * @throws ZAException 
     * @throws ParseException 
     */
    public void addBreedCertified(String memberNum, String breedDate, String malePedigreeCertified, String femalePedigreeCertified,String urgent) throws ZAException, ParseException {
        
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date breedTime = df.parse(breedDate);
        boolean memberValid = false;
        /*公犬CKU证书校验*/
        boolean ckuMaleDog = false;
        ckuMaleDog = malePedigreeCertified.contains("CKU-");
        Debugger.doAssert(ckuMaleDog, ZAErrorCode.ZA_DOG_NOT_FOUND, "公犬非CKU注册犬！");
        /*母犬CKU证书校验*/
        boolean ckuFemaleDog = false;
        ckuFemaleDog = femalePedigreeCertified.contains("CKU-");
        Debugger.doAssert(ckuFemaleDog, ZAErrorCode.ZA_DOG_NOT_FOUND, "母犬非CKU注册犬！");
        /*公母犬是否同一犬种校验*/
        String maleDogBreed = malePedigreeCertified.substring(4, malePedigreeCertified.length()-9);
        String femaleDogBreed = femalePedigreeCertified.substring(4,femalePedigreeCertified.length()-9);
        boolean dogBreedSame = maleDogBreed.equals(femaleDogBreed);
        Debugger.doAssert(dogBreedSame, ZAErrorCode.ZA_DOG_NOT_FOUND, "公母犬需是同一犬种！");
        /*校验申请配种的公犬数据*/
        String dogGender = "公";
        Dog maleDogInfo = breedCertifiedMapper.getDogInfo(memberNum,malePedigreeCertified,dogGender);
        Debugger.doAssert(maleDogInfo!=null, ZAErrorCode.ZA_DOG_NOT_FOUND, "公犬血统证书号错误或不在申请人名下！");
        Debugger.doAssert(maleDogInfo.getBirthday()!=null, ZAErrorCode.ZA_DOG_NOT_FOUND, "公犬出生信息错误，请联系CKU繁殖部修改！");
        long daysBetween = (breedTime.getTime()-maleDogInfo.getBirthday().getTime()+1000000)/(3600*24*1000);
        Debugger.doAssert(daysBetween>270, ZAErrorCode.ZA_DOG_NOT_FOUND, "公犬不满足配种年龄限制！");
        memberValid = publicService.getMemberStatus(maleDogInfo.getDogOwner());
        //专业会员校验
        Debugger.doAssert(memberValid, ZAErrorCode.ZA_DOG_NOT_FOUND, "公犬主会员无效！");
        /*校验申请配种的母犬数据*/
        dogGender = "母";
        Dog femaleDogInfo = breedCertifiedMapper.getDogInfo(null,femalePedigreeCertified,dogGender);
        Debugger.doAssert(femaleDogInfo!=null, ZAErrorCode.ZA_DOG_NOT_FOUND, "母犬血统证书号错误！");
        Debugger.doAssert(femaleDogInfo.getBirthday()!=null, ZAErrorCode.ZA_DOG_NOT_FOUND, "母犬出生信息错误，请联系CKU繁殖部修改！");
        daysBetween = (breedTime.getTime()-femaleDogInfo.getBirthday().getTime()+1000000)/(3600*24*1000);
        Debugger.doAssert(daysBetween>270, ZAErrorCode.ZA_DOG_NOT_FOUND, "母犬不满足配种年龄限制！");
        memberValid = publicService.getMemberStatus(femaleDogInfo.getDogOwner());
        //专业会员校验
        Debugger.doAssert(memberValid, ZAErrorCode.ZA_DOG_NOT_FOUND, "母犬主会员无效！");
        /*生成配种证明号 start*/
        StringBuffer breedCertifiedNum = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
        breedCertifiedNum.append(sdf.format(breedTime));
        breedCertifiedNum.append(memberNum);
        String maxBreedCertifiedNum = dogNewBornMapper.getMaxBreedCertifiedNum(breedCertifiedNum.toString());
        Integer newBreedCertifiedNum = null;
        if(maxBreedCertifiedNum!=null && !"".equals(maxBreedCertifiedNum)){
            newBreedCertifiedNum = new Integer(maxBreedCertifiedNum)+1;
            breedCertifiedNum.setLength(0);
            breedCertifiedNum.append(newBreedCertifiedNum.toString());
        } else {
            breedCertifiedNum.append("1");
        }
        /*生成配种证明号 end*/
        /*生成配种证明业务信息*/
        DogNewBorn dogNewBorn = new DogNewBorn();
        dogNewBorn.setTimestr(new Date());
        dogNewBorn.setPayout("7");
        dogNewBorn.setDogPeinum(breedCertifiedNum.toString());
        dogNewBorn.setDogHeadGong(maleDogInfo.getDogOwner());
        dogNewBorn.setDogGongUserid(maleDogInfo.getMemberNum());
        dogNewBorn.setDogHeadMu(femaleDogInfo.getDogOwner());
        dogNewBorn.setDogMuUserid(femaleDogInfo.getMemberNum());
        dogNewBorn.setDogNameGong(maleDogInfo.getDogEnName());
        dogNewBorn.setDogGongCard(maleDogInfo.getPedigreeCertified());
        dogNewBorn.setDogNameMu(femaleDogInfo.getDogEnName());
        dogNewBorn.setDogMuCard(femaleDogInfo.getPedigreeCertified());
        dogNewBorn.setDogClass(maleDogBreed);
        dogNewBorn.setDogPeiDate(breedTime);
        dogNewBorn.setDogCheck("待审核");
        dogNewBorn.setDogCheckWhy("会员提交");
        dogNewBorn.setDogGongXufei("是");
        dogNewBorn.setDogMuXufei("是");
        dogNewBorn.setDogWoFei("未交");
        dogNewBorn.setRecorder(maleDogInfo.getMemberNum());
        //TODO 根据提交的配种时间与当前时间比对，差两个月以上pid为99，反之pid为12
        //TODO 根据pid去cku_user_payType表中查询出对应的金额
        CkuPayType ckuPayType = ckuPayTypeMapper.getPayTypeByPid("99");
        //TODO 为业务订单金额赋值
        //dogNewBorn.setOrderPrice();
        dogNewBorn.setCkuJiaji(urgent);
    }

    
}
