package com.cab.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cab.dao.CabSysUserMapper;
import com.cab.dao.PointsDetailMapper;
import com.cab.dao.PointsTypeMapper;
import com.cab.model.CabSysUser;
import com.cab.model.PointsDetail;
import com.cab.model.PointsType;
import com.cku.util.PageBean;


/**
 * 
 * <p>Title:PointsDetailServiceImpl </p>
 * <p>Description: 积分明细</p>
 * <p>Company: </p> 
 * @author zhuoHeng
 * @date 2016年6月20日 下午2:56:42
 */
@Service("pointsDetailServiceImpl")
public class PointsDetailServiceImpl {

	@Autowired
	private PointsDetailMapper pointsDetailMapper;
	@Autowired
	private UtilServiceImpl utilService;
	@Autowired
	private CabSysUserMapper cabSysUserMapper;
	
	@Autowired
	private PointsTypeMapper pointsTypeMapper;
	
	/**
	 * 
	 * @Description：按天分组查询用户积分明细
	 * @author: zhuoHeng
	 * @version: 2016年6月20日 下午3:04:31
	 */
	public List<PointsDetail> getPointsDetail(String userId,PageBean pb){
		List<PointsDetail> list = pointsDetailMapper.getPointsDetail(userId,null,pb.get_start(),pb.get_limit());
		return list;
	}
	
	/**
	 * 
	 * @Description：获取今日积分及任务进度
	 * @author: zhuoHeng
	 * @version: 2016年6月20日 下午3:46:53
	 */
	public List<PointsDetail> getTodayPoints(String userId){
		List<PointsDetail> list = pointsDetailMapper.getTodayPoints(userId);
		PointsDetail pointsInformation = pointsDetailMapper.selectByType(5,userId);
		PointsDetail pointsLoveDog = pointsDetailMapper.selectByType(6,userId);
		PointsDetail pointsPhone = pointsDetailMapper.selectByType(7,userId);
		for (int i = 0; i < list.size(); i++) {
			//因特定任务（完善资料5、首次添加爱宠6、绑定手机7）不按天计算，此处将特定任务数据替换为不按天过滤的数据
			if(list.get(i).getType()==5){
				if(pointsInformation!=null){
					list.get(i).setTotal(1);
				} else {
					list.get(i).setTotal(0);
				}
			} else if(list.get(i).getType()==6){
				if(pointsLoveDog!=null){
					list.get(i).setTotal(1);
				} else {
					list.get(i).setTotal(0);
				}
			} else if(list.get(i).getType()==7){
				if(pointsPhone!=null){
					list.get(i).setTotal(1);
				} else {
					list.get(i).setTotal(0);
				}
			}
		}
		return list;
	}
	
	/**
	 * 
	 * @Description：微信分享后增加用户积分
	 * @author: zhuoHeng
	 * @version: 2016年6月21日 下午3:32:27
	 */
	public void addPartookPoints(String userId){
		utilService.addPoints(userId,3);
	}
	
	/**
	 * 
	 * @Description：查询所有积分类型信息
	 * @author: zhuoHeng
	 * @version: 2016年6月21日 下午5:59:57
	 */
	public List<PointsType> selectAllPointsType(){
		List<PointsType> list = pointsTypeMapper.selectAllPointsType();
		return list;
	}
	
	
	/**
	 * 
	 * @Description：获取登录用户总积分
	 * @author: zhuoHeng
	 * @version: 2016年6月23日 上午11:23:38
	 */
	public Integer selectPointsCount(String userId){
		Integer pointsCount = 0;
		CabSysUser cabSysUser = cabSysUserMapper.selectByPrimaryId(userId);
		if(cabSysUser!=null){
			pointsCount = cabSysUser.getPoints()==null?0:cabSysUser.getPoints();
		}
		return pointsCount;
	}
	
}
