package com.cku.service;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.cku.core.PageBeanResult;
import com.cku.dao.CkuCaiPanMapper;
import com.cku.model.CkuCaiPan;
import com.cku.util.PageBean;

@Service("ckuCaiPanService")
public class CkuCaiPanServiceImpl {
	@Autowired
	public CkuCaiPanMapper ckuCaiPanMapper;
	
	public PageBeanResult<CkuCaiPan> getList(String name,String position, PageBean pb){
		PageBeanResult<CkuCaiPan> pbr = new PageBeanResult<CkuCaiPan>();
		List<CkuCaiPan> list = ckuCaiPanMapper.getList(name,position,pb.get_limit(),pb.get_start());
		pbr.list = list;
		pbr.totalCount = ckuCaiPanMapper.getCount(name,position);
		return pbr;
	}
	public CkuCaiPan getModelById(long id){
		CkuCaiPan result= ckuCaiPanMapper.getCaiPanById(id);
		return result;
	}
	public int updateCaiPan(CkuCaiPan ckuCaiPan) {
		int i = ckuCaiPanMapper.updateByPrimaryKeySelective(ckuCaiPan);
		return i;
	}

	public int deleteCaiPan(long id) {
		int i = ckuCaiPanMapper.deleteByPrimaryKey(id);
		return i;
	}

	public int addCaiPan(CkuCaiPan ckuCaiPan) {
		int i = ckuCaiPanMapper.insertSelective(ckuCaiPan);
		return i;
	
	}
	
	public List<CkuCaiPan> getCaiPan(){
		return ckuCaiPanMapper.getCaiPan();
	}



}
