package com.cab.test.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.util.ServletUtils;

/**
 * 接口测试接口，用于检查客户端是否支持标准的数据提交和请求
 * @author fanhuibin
 *
 */
@Controller
@RequestMapping(value="/v1")
public class TestController {
	Logger logger = LoggerFactory.getLogger(TestController.class);
			
	@RequestMapping(value="/test", method=RequestMethod.GET)
	@ResponseBody
	public void get(HttpServletRequest request,HttpServletResponse response) throws IOException{
		logger.debug("测试GET方法成功");
		RESTResponse result=new RESTResponse("method","GET");
		ServletUtils.writeResponse(response, result);
	}
	
	@RequestMapping(value="/test", method=RequestMethod.POST)
	@ResponseBody
	public void post(HttpServletRequest request,HttpServletResponse response) throws IOException{
		logger.debug("测试POST方法成功");
		RESTResponse result=new RESTResponse("method","POST");
		ServletUtils.writeResponse(response, result);
	}
	
	@RequestMapping(value="/test", method=RequestMethod.PUT)
	@ResponseBody
	public void put(HttpServletRequest request,HttpServletResponse response) throws IOException{
		logger.debug("测试PUT方法成功");
		RESTResponse result=new RESTResponse("method","PUT");
		ServletUtils.writeResponse(response, result);
	}
	
	@RequestMapping(value="/test", method=RequestMethod.DELETE)
	@ResponseBody
	public void delete(HttpServletRequest request,HttpServletResponse response) throws IOException{
		logger.debug("测试DELETE方法成功");
		RESTResponse result=new RESTResponse("method","DELETE");
		ServletUtils.writeResponse(response, result);
	}
	
}
