package com.sys.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cku.core.RESTResponse;
import com.cku.util.ServletUtils;
import com.sys.model.Version;
import com.sys.service.VersionServiceImpl;
import com.sys.util.SmCryptoUtil;

import cn.hutool.core.util.RandomUtil;

/**
 * user chaixueteng 2016年5月30日
 */
@Controller
@RequestMapping("version")
public class VersionController {

	@Autowired
	public VersionServiceImpl versionServiceImpl;

	/**
	 * 得到当前版本号(android)
	 * 
	 * @throws IOException
	 * @Author chaixueteng
	 * @2016年5月30日上午11:10:16
	 */
	@RequestMapping(value = "getVersion")
	public void getVersion(HttpServletResponse response, HttpServletRequest request) throws IOException {
		RESTResponse result = null;
		String version = request.getParameter("androidVersion");
		try {
			result = new RESTResponse("android", getAndroidVersion(version));
		} catch (Exception e) {
			result = new RESTResponse(-1, e.getMessage());
		}
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 得到当前版本号(ios)
	 * 
	 * @throws IOException
	 * @Author chaixueteng
	 * @2016年5月30日上午11:10:16
	 */
	@RequestMapping(value = "getIOSVersion")
	public void getIOSVersion(HttpServletResponse response, HttpServletRequest request) throws IOException {
		RESTResponse result = null;
		String iosVersion = request.getParameter("iosVersion");
		try {
			result = new RESTResponse("IOSVersion", getIOSVersion(iosVersion));
		} catch (Exception e) {
			result = new RESTResponse(-1, e.getMessage());
		}
		ServletUtils.writeResponse(response, result);
	}

	private Map<String, Object> getAndroidVersion(String version) {
		Map<String, Object> map = new HashMap<String, Object>();
		// 查询最新版本
		Version newAndroid = versionServiceImpl.getNewAndroid();
		map.put("androidVersion", newAndroid.getVersion());
		map.put("AndroidName", newAndroid.getAndroidName());
		String uuid = RandomUtil.randomString(4).concat("cku-apk").concat(RandomUtil.randomString(4));
		System.out.println(uuid);
		map.put("androidDownload",
				"https://app.chongaibao.com/apk/download/app?uuid=".concat(SmCryptoUtil.doSm4CbcEncrypt(uuid)));
		map.put("androidUpdate", newAndroid.getAndroidUpdate());

		// 入参为空
		if (StringUtils.isEmpty(version)) {
			map.put("androidUpdate", 1);
			return map;
		}
		// 跨版本是否有强更
		Version v = versionServiceImpl.selectByAndroidName(version);
		if (v == null) {
//			throw new RuntimeException("版本号错误");
			map.put("androidUpdate", newAndroid.getAndroidUpdate());
			return map;
		}
		List<Version> andrioidList = versionServiceImpl.getAndroidList(v);
		for (Version ver : andrioidList) {
			if (ver.getAndroidUpdate() == 1) {
				map.put("androidUpdate", 1);
			}
		}
		return map;
	}

	private Map<String, Object> getIOSVersion(String versoin) {
		Map<String, Object> map = new HashMap<String, Object>();
		// 查询最新版本
		Version IOSVersion = versionServiceImpl.getNewVersion();
		map.put("iosVersion", IOSVersion.getIosVersion());
		map.put("iosUpdate", IOSVersion.getIosUpdate());
		// 入参为空
		if (StringUtils.isEmpty(versoin)) {
			map.put("iosUpdate", 1);
			return map;
		}
		// 跨版本是否有强更
		Version v = versionServiceImpl.getIOSVersion(versoin);
		if (v == null) {
//			throw new RuntimeException("版本号错误");
			map.put("iosUpdate", IOSVersion.getIosUpdate());
			return map;
		}
		List<Version> iosList = versionServiceImpl.getIosList(v);
		for (Version ver : iosList) {
			if (ver.getIosUpdate() == 1) {
				map.put("iosUpdate", 1);
			}
		}
		return map;
	}

	/**
	 * 添加安卓版本信息
	 * 
	 * @Author chaixueteng
	 * @2016年8月16日上午11:18:04
	 */
//	@RequestMapping(value = "addAndroidVersion")
//	public void addVersionMessage(HttpServletResponse response, HttpServletRequest request) throws IOException {
//		RESTResponse result = null;
//		try {
//			String version = ServletUtils.getParameter(request, "version", null);
//			String androidName = ServletUtils.getParameter(request, "androidName", null);
//			String androidDownload = ServletUtils.getParameter(request, "androidDownload", null);
//			String update = ServletUtils.getParameter(request, "update", null);
//			versionServiceImpl.insertVersion(version, androidName, androidDownload, update);
//			result = new RESTResponse();
//		} catch (Exception e) {
//			result = new RESTResponse(e);
//			e.printStackTrace();
//		}
//		ServletUtils.writeResponse(response, result);
//	}

	/**
	 * 添加ios版本信息
	 * 
	 * @Author chaixueteng
	 * @2016年8月16日上午11:18:04
	 */
//	@RequestMapping(value = "addIOSVersion")
//	public void addIOSVersion(HttpServletResponse response, HttpServletRequest request) throws IOException {
//		RESTResponse result = null;
//		try {
//			String iosVersion = ServletUtils.getParameter(request, "iosVersion", null);
//			String update = ServletUtils.getParameter(request, "update", null);
//			versionServiceImpl.insertIOSVersion(iosVersion, update);
//			result = new RESTResponse();
//		} catch (Exception e) {
//			result = new RESTResponse(e);
//			e.printStackTrace();
//		}
//		ServletUtils.writeResponse(response, result);
//	}

}
