package com.sys.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.util.ServletUtils;
import com.sys.model.City;
import com.sys.service.CityServiceImpl;

@Controller
@RequestMapping(value="sys-api/city")
public class CityController {
	// private static final Logger logger = Logger.getLogger(ProvinceController.class);
	
	@Autowired
	public CityServiceImpl cityService;
	
	@RequestMapping(value = "/list")
	public void api_list(HttpServletResponse response,HttpServletRequest request) throws IOException
	{
		RESTResponse result = null;
		try
		{
			String provinceCode = ServletUtils.getParameter(request, "province_code");
			PageBeanResult<City> lp = cityService.getList(provinceCode);
			result = new RESTResponse("items", lp);
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}
		
		ServletUtils.writeResponse(response, result);
	}
}
