package com.cku.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cku.service.CkuDogClassServiceImpl;

@Controller
@RequestMapping(value = "ckuDogClass")
public class CkuDogClassController {
	private static final Logger logger = Logger.getLogger(CkuDogClassController.class);
	@Autowired
	public CkuDogClassServiceImpl ckuDogClassService;
	@RequestMapping(value="getAll")
	public void getDogClass(HttpServletRequest request, HttpServletResponse response,
			@RequestParam(value = "name", required = false)String name,
			@RequestParam(value = "hot", required = false)String hot){
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = ckuDogClassService.getDogClass(name,hot);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e);
		}
	}
	
}
