package com.cku.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cab.service.UserService;
import com.cku.core.RESTResponse;
import com.cku.service.UserRelatedServiceImpl;
import com.cku.util.ServletUtils;

/**
 * 
 * <p>Title:UserRelatedController </p>
 * <p>Description:用户相关接口 </p>
 * <p>Company: </p> 
 * @author zhuoHeng
 * @date 2016年3月17日 上午9:16:46
 */
@Controller
@RequestMapping(value="user")
public class UserRelatedController {
	
	private static final Logger logger = Logger.getLogger(EventRelatedController.class);
	
	@Autowired
	public UserRelatedServiceImpl userRelatedServiceImpl;
	
	/**
	 * @Description：根据牵犬师会员号查询会员信息
	 * @author: zhuoHeng
	 * @version: 2016年3月17日 上午9:21:28
	 */
	@RequestMapping(value = "/getUserMessage")
	public void getDogMessage(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "idNum", required = false)String idNum){
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = userRelatedServiceImpl.getUserMessage(idNum);
			System.out.println("------getDogMessage:"+str);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
	/**
	 * 
	 * @Description：根据登录者会员号获取登录会员的常用牵犬师
	 * @author: zhuoHeng
	 * @version: 2016年3月17日 上午9:52:52
	 */
	@RequestMapping(value = "/getFrequentlyUsedUsers")
	public void getFrequentlyUsedUsers(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "idNum", required = false)String idNum){
		try {
			//320106198002180821
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = userRelatedServiceImpl.getFrequentlyUsedUsers(idNum);
			System.out.println("------getFrequentlyUsedUsers:"+str);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
	/**
	 * 
	 * @Description：保存常用牵犬师
	 * @author: zhuoHeng
	 * @version: 2016年3月17日 上午11:03:10
	 */
	@RequestMapping(value = "/saveFrequentlyUsedUser")
	public void saveFrequentlyUsedUser(HttpServletResponse response,HttpServletRequest request,
			//牵犬师会员号
			@RequestParam(value = "idNum", required = false)String idNum,
			//登录人会员号
			@RequestParam(value = "login_user_num", required = false)String login_user_num,
			//牵犬师姓名
			@RequestParam(value = "user_name", required = false)String user_name,
			//牵犬师联系方式
			@RequestParam(value = "mobile_phone", required = false)String mobile_phone){
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = userRelatedServiceImpl.saveFrequentlyUsedUser(idNum,login_user_num,user_name,mobile_phone);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
	/**
	 * 
	 * @Description：判断是否为新会员
	 * @author: zhuoHeng
	 * @version: 2016年3月17日 下午7:31:59
	 */
	@RequestMapping(value = "/newVipStatus")
	public void newVipStatus(HttpServletResponse response,HttpServletRequest request)throws IOException{
		RESTResponse result=null;
		try {
			String userId = UserService.verifyThirdUserId(request);
			String i = userRelatedServiceImpl.newVipStatus(userId);
			if ("1".equals(i)) {
				result=new RESTResponse(1,"不是新会员");
				//新会员标识为"0"
			}else if("0".equals(i)){
				result=new RESTResponse(0,"是新会员");
			}
		} catch (Exception e) {
			result = new RESTResponse(e);
			e.printStackTrace();
		}
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 
	 * @Description：根据登录会员号和所选牵犬师会员号查询常用牵犬师详细
	 * @author: zhuoHeng
	 * @version: 2016年3月18日 上午9:22:51
	 */
	@RequestMapping(value = "/getFrequentlyUsedUserInfo")
	public void getFrequentlyUsedUserInfo(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "idNum", required = false)String idNum,
			@RequestParam(value = "loginUserNum", required = false)String loginUserNum){
		try {
			//320106198002180821
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = userRelatedServiceImpl.getFrequentlyUsedUserInfo(idNum,loginUserNum);
			System.out.println("------getFrequentlyUsedUserInfo:"+str);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
	
}
