package com.cku.controller;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.cku.core.RESTResponse;
import com.cku.model.DogName;
import com.cku.service.DogNameServiceImpl;
import com.cku.util.ServletUtils;

/**
 * 
 * <p>Title:DogNameController </p>
 * <p>Description:犬名控制层 </p>
 * <p>Company: </p> 
 * @author zhuoHeng
 * @date 2016年7月27日 下午3:01:16
 */
@Controller
@RequestMapping(value = "dog/dogName")
public class DogNameController {
    @Autowired
    public DogNameServiceImpl dogNameService;
//    @Autowired
//    public ChampionLoginService championLoginService;
    
    /**
     * 
     * @Description：获取随机犬名
     * @author: zhuoHeng
     * @version: 2016年7月27日 下午3:01:49
     * @throws IOException 
     */
    @RequestMapping(value = "/RandomDogName",method = RequestMethod.GET)
    public void getRandomDogName(HttpServletRequest request,HttpServletResponse response) throws IOException{
        RESTResponse result = null;
        try {
            Integer maleNumber = ServletUtils.getParameterInt(request, "maleNumber",null);
            Integer femaleNumber = ServletUtils.getParameterInt(request, "femaleNumber",null);
            List<DogName> list = dogNameService.getRandomDogName(maleNumber,femaleNumber);
            result = new RESTResponse("data", list);
        } catch (Exception e) {
            result = new RESTResponse(e);
        }
        ServletUtils.writeResponse(response, result);
    }
    

}
