package com.cku.controller;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.model.CkuImage;
import com.cku.model.CkuMatchHotel;
import com.cku.service.CkuMatchHotelServiceImpl;
import com.cku.util.PageBean;
import com.cku.util.ServletUtils;

@Controller
@RequestMapping(value="ckuMatchHotel")
public class CkuMatchHotelController {
	private static final Logger logger = Logger.getLogger(CkuMatchHotelController.class);
	@Autowired
	public CkuMatchHotelServiceImpl ckuMatchHotelService;
	
	//得到所有接口
	@RequestMapping(value="/getHotel")
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void getHotel(@RequestParam(value = "showLocation", required = false)String showLocation,
			HttpServletResponse response,HttpServletRequest request) {
		try {
			//showLocation =new String(showLocation.getBytes("ISO-8859-1"),"UTF-8");//字符转换 
			System.out.println("test--------------");
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String result = ckuMatchHotelService.getHotel(showLocation);
		    response.getWriter().write(result);
		} catch (Exception e) {
			// TODO: handle exception
			logger.error(e);
		}
	}
	
	//得到ModalList
	@RequestMapping(value="/getListModal")
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void getListModal(HttpServletResponse response,HttpServletRequest request) throws IOException {
		RESTResponse result = null;
		try{
			String name = ServletUtils.getParameter(request, "name",null);
			PageBean pb = ServletUtils.getParameterBean(request);
			PageBeanResult<CkuMatchHotel> list = ckuMatchHotelService.getList(name,null,pb);
			result = new RESTResponse("items", list);
		}catch (Exception e){
			result = new RESTResponse(e);
			logger.error(e);
		}
		ServletUtils.writeResponse(response, result);

	}
	
	/**
	 * 
	 * @param response
	 * @param request
	 * @throws IOException
	 */
	@RequestMapping(value="/getList")
	public ModelAndView getList(HttpServletResponse response,HttpServletRequest request,ModelMap modelMap) throws IOException {
		String hotelName = ServletUtils.getParameter(request, "hotelName",null);
		String hotelAddress = ServletUtils.getParameter(request, "hotelAddress",null);
		PageBean pb = ServletUtils.getParameterBean(request);
		PageBeanResult<CkuMatchHotel> s = ckuMatchHotelService.getList(hotelName,hotelAddress,pb);
		modelMap.addAttribute("pageList",s);
		ModelAndView mv = new ModelAndView("admin/ckuMatchHotel/matchHotelList",modelMap);
		return mv;
	
	}
	/**
	 * 
	 */
	@RequestMapping(value="/toUpdate")
	public ModelAndView toUpdate(HttpServletResponse response,HttpServletRequest request, ModelMap modelMap) throws IOException{
		 String type = ServletUtils.getParameter(request, "type","add");
		 if("edit".equals(type)){
			 long id = ServletUtils.getParameterLong(request, "id",null);
			 CkuMatchHotel cmh =null;
			 List<CkuImage> list=ckuMatchHotelService.getImageById(id);
			 if (list.size()>0) {
				cmh = ckuMatchHotelService.selectByPrimaryKey(id);
			}else{
				cmh = ckuMatchHotelService.selectById(id);
			}
			 modelMap.addAttribute("matchHotel",cmh);
		 }else{
			 modelMap.addAttribute("matchHotel",null);
		 }
		ModelAndView mv = new ModelAndView("admin/ckuMatchHotel/updateMatchHotel",modelMap);
		return mv;
	}


	/**
	 * 新增赛事酒店
	 * @author 柴雪腾
	 * @param response
	 * @param request
	 */
	@RequestMapping(value="/addMatchHotel")
	public ModelAndView addMatchHotel(HttpServletResponse response,HttpServletRequest request,CkuMatchHotel ckuMatchHotel, ModelMap modelMap)throws IOException{

		//TODO 酒店添加放到service里处理逻辑。   添加经纬度，  添加创建时间
		int i = ckuMatchHotelService.addMatchHotel(ckuMatchHotel);
		String result = i>0?"success":"error";
		modelMap.addAttribute("toPage","ckuMatchHotel/getList.do");
		modelMap.addAttribute("message",i>0?"添加赛事酒店成功!":"添加赛事酒店失败!");
		ModelAndView mv = new ModelAndView(result,modelMap);
		return mv;
	}
	/**
	 * 修改赛事酒店
	 * @param response
	 * @param request
	 */
	@RequestMapping(value="/updateMatchHotel")
	public ModelAndView updateMatchHotel(HttpServletResponse response,HttpServletRequest request,CkuMatchHotel ckuMatchHotel, ModelMap modelMap)throws IOException{
		//TODO  酒店修改放到service里处理逻辑。   修改经纬度，  修改时间
		int i = ckuMatchHotelService.updateMatchHotel(ckuMatchHotel);
		String result = i>0?"success":"error";
		modelMap.addAttribute("toPage","ckuMatchHotel/getList.do");
		modelMap.addAttribute("message",i>0?"修改赛事酒店成功!":"修改赛事酒店失败!");
		ModelAndView mv = new ModelAndView(result,modelMap);
		return mv;
	}
	/**
	 * 删除赛事酒店
	 * @param response
	 * @param request
	 */
	@RequestMapping(value="/deleteMatchHotel")
	@ResponseBody
	public void deleteMatchHotel(HttpServletResponse response,HttpServletRequest request)throws IOException{
		RESTResponse result = null;
		try{
			long id = ServletUtils.getParameterLong(request, "id",null);
			int i = ckuMatchHotelService.deleteByPrimaryKey(id);
			if(i>0){
				result = new RESTResponse(0,"删除赛事酒店成功！");
			}else{
				result = new RESTResponse(1,"删除赛事酒店失败！");
			}
		}catch (Exception e){
			result = new RESTResponse(e);
			logger.error(e);
		}
		ServletUtils.writeResponse(response, result);
	}
}
