package com.sys.controller;

import com.sys.service.CKUOauth2ClientServiceImpl;
import com.sys.service.OAuthServiceImpl;
import org.apache.oltu.oauth2.common.OAuth;
import org.apache.oltu.oauth2.common.error.OAuthError;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.OAuthResponse;
import org.apache.oltu.oauth2.common.message.types.ParameterStyle;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.rs.request.OAuthAccessResourceRequest;
import org.apache.oltu.oauth2.rs.response.OAuthRSResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by user on 2016/4/27.
 */
@Controller
@RequestMapping("ckuoauth2")
public class CKUOauth2UserInfoController {
    @Autowired
    private CKUOauth2ClientServiceImpl ckuOauth2ClientService;
    @RequestMapping("userInfo")
    public HttpEntity userInfo(Model model,HttpServletRequest request) throws OAuthSystemException {
            try {
                //构建OAuth资源请求
                OAuthAccessResourceRequest oauthRequest = new OAuthAccessResourceRequest(request, ParameterStyle.QUERY);
                //获取Access Token
                String accessToken = oauthRequest.getAccessToken();
                //验证Access Token
                if (!ckuOauth2ClientService.checkAccessToken(accessToken)) {
                    // 如果不存在/过期了，返回未验证错误，需重新验证
                    OAuthResponse oauthResponse = OAuthRSResponse
                            .errorResponse(HttpServletResponse.SC_UNAUTHORIZED)
                            .setRealm("caibmobile")
                            .setError(OAuthError.ResourceResponse.INVALID_TOKEN)
                            .buildHeaderMessage();

                    HttpHeaders headers = new HttpHeaders();
                    headers.add(OAuth.HeaderType.WWW_AUTHENTICATE, oauthResponse.getHeader(OAuth.HeaderType.WWW_AUTHENTICATE));
                    return new ResponseEntity(headers, HttpStatus.UNAUTHORIZED);
                }
                //返回用户名
                String username = ckuOauth2ClientService.getAccessToken(accessToken);
                return new ResponseEntity(username, HttpStatus.OK);
            } catch (OAuthProblemException e) {
                //检查是否设置了错误码
                String errorCode = e.getError();
                if (OAuthUtils.isEmpty(errorCode)) {
                    OAuthResponse oauthResponse = OAuthRSResponse
                            .errorResponse(HttpServletResponse.SC_UNAUTHORIZED)
                            .setRealm("caibmobile")
                            .buildHeaderMessage();

                    HttpHeaders headers = new HttpHeaders();
                    headers.add(OAuth.HeaderType.WWW_AUTHENTICATE, oauthResponse.getHeader(OAuth.HeaderType.WWW_AUTHENTICATE));
                    return new ResponseEntity(headers, HttpStatus.UNAUTHORIZED);
                }

                OAuthResponse oauthResponse = OAuthRSResponse
                        .errorResponse(HttpServletResponse.SC_UNAUTHORIZED)
                        .setRealm("caibmobile")
                        .setError(e.getError())
                        .setErrorDescription(e.getDescription())
                        .setErrorUri(e.getUri())
                        .buildHeaderMessage();

                HttpHeaders headers = new HttpHeaders();
                headers.add(OAuth.HeaderType.WWW_AUTHENTICATE, oauthResponse.getHeader(OAuth.HeaderType.WWW_AUTHENTICATE));
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
    }
}
