package com.cku.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cku.core.PageBeanResult;
import com.cku.dao.CkuDogMapper;
import com.cku.dao.CkuDvUserMapper;
import com.cku.dao.CkuGjdlMapper;
import com.cku.dao.CkuMatchMapper;
import com.cku.dao.CkuShowsBaoMingMapper;
import com.cku.dao.CkuUserMapper;
import com.cku.dao.CkuUserPayListMapper;
import com.cku.dao.CkuUserPayTypeMapper;
import com.cku.dao.SPCartsMapper;
import com.cku.dao.SPOrderInfoMapper;
import com.cku.model.CkuDvUserModel;
import com.cku.model.CkuGjdl;
import com.cku.model.CkuShowsBaoMing;
import com.cku.model.OrderDetilInfo;
import com.cku.model.SPOrderInfoNew;
import com.cku.util.PageBean;

/**
 *user chaixueteng
 *2016年4月14日
 */
@Service(value="OrderService")
public class OrderServiceImpl {
	@Autowired
	public CkuUserPayListMapper ckuUserPayListMapper;
	@Autowired
	public SPCartsMapper spCartsMapper;
	@Autowired
	public CkuUserMapper ckuUserMapper;
	@Autowired
	public CkuGjdlMapper ckuGjdlMapper;
	@Autowired
	public CkuDvUserMapper ckuDvUserMapper;
	@Autowired
	public CkuShowsBaoMingMapper ckuShowsBaoMingMapper;
	@Autowired
	public CkuUserPayTypeMapper ckuUserPayTypeMapper;
	@Autowired
	public SPOrderInfoMapper spOrderInfoMapper;
	@Autowired
	public CkuMatchMapper ckuMatchMapper;

	@Autowired
	public CkuDogMapper ckuDogMapper;
	//
	String [] typeIds= new String[]{"140","141","142","219","220","221","222","298","298zz","299","299zz","367","368","369","370","371","372","45","1099","1073","1070"
			,"1027","1030","1033","1036","1039","1042"};
	String [] couponIds= new String[]{"25c04f060c1f4314bb7b7d18aeb7b915","5809c0665c6c4bb39ed02c749fa1e134","73989b7f0c874729b76d5289b702064a",
			"9dae72e17dbd43bdaa361ce8f64c563d","a995e065c4294b25b2ebbd6f56a31795","d64061366fa245bc902c542807e2d998","f0eef5f34b864a9294e3d4e03561179a"};
	/**
	 * 已改
	 * @Description：根据登录人会员号查询订单
	 * @author: zhuoHeng
	 * @version: 2016年9月9日 下午2:28:18
	 */
	public PageBeanResult<SPOrderInfoNew> getOrderListNew(String thirdUserId, String payState, PageBean pb) {
        String ckuId = "-1";
        //根据CKU账号id查询出CKU账号信息
        CkuDvUserModel ckuDvUserModel = ckuDvUserMapper.getckuMemberByUserId(thirdUserId);
        if(ckuDvUserModel != null){
            ckuId = ckuDvUserModel.getCkuId();
        }
        PageBeanResult<SPOrderInfoNew> pbr=new PageBeanResult<SPOrderInfoNew>();
        long start = pb.get_start();
        long limit = pb.get_limit();
        //因支付状态更改，对支付状态进行转换
        if("1".equals(payState)){
        	payState = "2";
        } else if ("0".equals(payState)) {
        	payState = "1";
        }
        //根据用户id和订单的支付状态查询所有已支付订单
        List<SPOrderInfoNew> orderList = spOrderInfoMapper.selectPayOrderNew(ckuId,payState,start,limit);
        pbr.list=orderList;
        if (pb.getNeedCount()) {
            pbr.totalCount=spOrderInfoMapper.getCount(ckuId,payState);
        }
        return pbr;
    }


	/**
	 * 订单详情页
	 *
	 * @param orderId
	 * @param payState
	 * @param typeId
	 * @param pedigreeCertified
	 * @param payType
	 * @return
	 */
	@SuppressWarnings("all")
	public OrderDetilInfo getOrderDetil(String orderId, String typeId, String pedigreeCertified) {

		if (Arrays.asList(typeIds).contains(typeId) || Arrays.asList(couponIds).contains(typeId)) {
			//判断类型是否为犬只参赛 是则查询报名表里的信息
			CkuShowsBaoMing ckuShowsBaoMing=ckuShowsBaoMingMapper.getCkuDagId(orderId,pedigreeCertified);
			//根据订单号查询报名表里面的cku血统证号
			String ckuStudbookNum = ckuShowsBaoMing.getCkuStudbookNum();
			//业务状态
			String payout = ckuShowsBaoMing.getPayout();
			//得到赛事编号 查询赛事信息
			String showNum = ckuShowsBaoMing.getShowNum();
			//得到赛事编号
			String[] showNums = showNum.split(",");
			//新的存放赛事信息的集合
			List matchMsg= new ArrayList();
			for (String string : showNums) {
				//查询赛事信息
				String matchMessage=ckuMatchMapper.getMatchMessage(string.trim());
				matchMsg.add(matchMessage);
			}
			//年龄组别
			String ageGroup = ckuShowsBaoMing.getAgeGroup();
			return new OrderDetilInfo(ckuStudbookNum, null, null, payout, null, matchMsg, ageGroup);
		//其他类型的业务详情
		}else {
			//如果是冠军登录类型就查询冠军登录表
			CkuGjdl ckuGjdl= new CkuGjdl();//ckuGjdlMapper.getLoginType(orderId);
			StringBuffer sb=new StringBuffer();
			sb.append(ckuGjdl.getPayout());
			sb.append(" ");
			sb.append(ckuGjdl.getInfoConfirm());
			String string = sb.toString();
			//得到cku血统证书号
			String ckuZsid = ckuGjdl.getCkuZsid();
			//根据cku血统证书号得到芯片号
			String dogCord=ckuDogMapper.getDogCord(ckuZsid);
			//登录类型
			String ckuDltype = ckuGjdl.getCkuDltype();
			//领取方式
			String ckuYjtype = ckuGjdl.getCkuYjtype();
			return new OrderDetilInfo(ckuZsid, dogCord, ckuDltype, string, ckuYjtype, null, null);
		}

	}

}
