package com.cku.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cab.service.UserService;
import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.model.OrderDetilInfo;
import com.cku.model.SPOrderInfoNew;
import com.cku.service.OrderServiceImpl;
import com.cku.util.PageBean;
import com.cku.util.ServletUtils;

/**
 *user chaixueteng
 *2016年4月14日
 */
@Controller
@RequestMapping(value="sys-api/order")
public class MyOrderController {
	

	
	@Autowired
	public OrderServiceImpl  orderServiceImpl;
	/**
	 * 根据当前登录人,订单状态查询我的订单中所有的订单
	 */
	@RequestMapping(value="/getOrderList")
	public void getOrderList(HttpServletResponse response,HttpServletRequest request)throws IOException{
		RESTResponse result = null;
		try {
			String userId = UserService.verifyThirdUserId(request);
			String payconfirm = ServletUtils.getParameter(request, "payconfirm");
			PageBean pb=ServletUtils.getParameterBean(request);
			PageBeanResult<SPOrderInfoNew> list=orderServiceImpl.getOrderListNew(userId, payconfirm,pb);
			result=new RESTResponse("items",list);
		
		} catch (Exception e) {
			result = new RESTResponse(e);
			e.printStackTrace();
		}
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 
	 * @Description：根据当前登录人,订单状态查询我的订单中所有的订单(new)
	 * @author: zhuoHeng
	 * @version: 2016年7月12日 下午5:25:52
	 */
	@RequestMapping(value="/getOrderListNew")
    public void getOrderListNew(HttpServletResponse response,HttpServletRequest request)throws IOException{
        RESTResponse result = null;
        try {
        	String userId = UserService.verifyThirdUserId(request);
            String payconfirm = ServletUtils.getParameter(request, "payconfirm");
            PageBean pb=ServletUtils.getParameterBean(request);
            PageBeanResult<SPOrderInfoNew> list=orderServiceImpl.getOrderListNew(userId, payconfirm,pb);
            result=new RESTResponse("items",list);
        
        } catch (Exception e) {
            result = new RESTResponse(e);
            e.printStackTrace();
        }
        ServletUtils.writeResponse(response, result);
    }
	
	/**
	 * 根据订单号,查询订单详细信息
	 */
	@RequestMapping(value="/getOrderMessage")
	public void getOrderMessage(HttpServletResponse response,HttpServletRequest request)throws IOException{
		RESTResponse result=null;
		try {
			String orderId = ServletUtils.getParameter(request, "orderId");
			String typeId = ServletUtils.getParameter(request, "typeId");
			String pedigreeCertified = ServletUtils.getParameter(request, "pedigreeCertified",null);
			OrderDetilInfo orderDetilInfo=orderServiceImpl.getOrderDetil(orderId,typeId,pedigreeCertified);
			result=new RESTResponse("items",orderDetilInfo);
		} catch (Exception e) {
			result = new RESTResponse(e);
			e.printStackTrace();
		}
		ServletUtils.writeResponse(response, result);
	}
	
}
