package com.sys.util;

import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.cku.config.Global;

public final class TokenUtil {

	private static Logger log = LoggerFactory.getLogger(TokenUtil.class);
	
	public static final long DEFAULT_TIMEOUT = 2592000000L;

	public static final String ENCODE_HEADER_NAME = "token";

	//为兼容线上TOKEN不过期，生产保留原值develop，开发测试环境变更为devtest
	private static final String ISSUER = Global.isProductMode() ? "develop" : "devtest";

	private static final String SECRET = "ertyuiopyuiopoppom324klkjhgfghjkl";

	private TokenUtil() {
	}

	public static String createJwt(String subject, long ttlMillis) {
		log.info("=====jwt.token.issuer=====" + ISSUER);
		return JWT.create().withExpiresAt(new Date(System.currentTimeMillis() + ttlMillis)).withIssuedAt(new Date())
				.withSubject(subject).withIssuer(ISSUER).sign(Algorithm.HMAC256(SECRET));//iss（发布者）   sign签名
	}

	public static DecodedJWT parseJwt(String token) {
		log.info("=====jwt.token.issuer=====" + ISSUER);
		return JWT.require(Algorithm.HMAC256(SECRET)).withIssuer(ISSUER).build().verify(token);
	}

}
